/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.panels.modeler.backend.indexing;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.enterprise.inject.Instance;
import org.apache.lucene.search.Query;
import org.jbpm.examples.purchases.PurchaseOrder;
import org.jbpm.examples.purchases.PurchaseOrderHeader;
import org.jbpm.examples.purchases.PurchaseOrderLine;
import org.jbpm.formModeler.core.config.DataHolderManagerImpl;
import org.jbpm.formModeler.core.config.FieldTypeManager;
import org.jbpm.formModeler.core.config.FieldTypeManagerImpl;
import org.jbpm.formModeler.core.config.FormManagerImpl;
import org.jbpm.formModeler.core.config.FormSerializationManager;
import org.jbpm.formModeler.core.config.FormSerializationManagerImpl;
import org.jbpm.formModeler.core.config.builders.dataHolder.DataHolderBuilder;
import org.jbpm.formModeler.core.config.builders.dataHolder.PojoDataHolderBuilder;
import org.jbpm.formModeler.core.config.builders.fieldType.ComplexFieldTypeBuilder;
import org.jbpm.formModeler.core.config.builders.fieldType.DecoratorFieldTypeBuilder;
import org.jbpm.formModeler.core.config.builders.fieldType.SimpleFieldTypeBuilder;
import org.jbpm.formModeler.core.model.PojoDataHolder;
import org.jbpm.formModeler.dataModeler.integration.DataModelerService;
import org.jbpm.formModeler.editor.type.FormResourceTypeDefinition;
import org.jbpm.formModeler.panels.modeler.backend.indexing.TestFormIndexer;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.screens.datamodeller.backend.server.DataModelTestUtil;
import org.kie.workbench.common.screens.datamodeller.backend.server.DataModelerServiceImpl;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.refactoring.backend.server.BaseIndexingTest;
import org.kie.workbench.common.services.refactoring.backend.server.TestIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.SingleTermQueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValuePartReferenceIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueReferenceIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.uberfire.ext.metadata.engine.Index;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={PojoDataHolder.class})
public class IndexFormsTest
extends BaseIndexingTest<FormResourceTypeDefinition> {
    private static final FieldTypeManager testFieldTypeManager = new FieldTypeManagerImpl(){
        {
            this.builders = new MockEmptyInstance<SimpleFieldTypeBuilder>(new SimpleFieldTypeBuilder());
            this.decoratorBuilders = new MockEmptyInstance<DecoratorFieldTypeBuilder>(new DecoratorFieldTypeBuilder());
            this.complexBuilders = new MockEmptyInstance<ComplexFieldTypeBuilder>(new ComplexFieldTypeBuilder());
        }
    };

    @Before
    public void setupStaticMockAndDataModelService() {
        PowerMockito.mockStatic(PojoDataHolder.class, (Answer)new Answer<FieldTypeManager>(){

            public FieldTypeManager answer(InvocationOnMock invocation) throws Throwable {
                return testFieldTypeManager;
            }
        });
    }

    @Test
    public void testIndexTestScenario() throws Exception {
        String[] formFiles = new String[]{"CreateOrder-taskform.form", "FixOrder-taskform.form", "PurchaseHeader.form", "PurchaseLine.form", "Purchases.Purchases-taskform.form", "ReviewAdministration-taskform.form", "ReviewCFO-taskform.form", "ReviewController-taskform.form", "ReviewManager-taskform.form"};
        Path[] path = new Path[formFiles.length];
        for (int i = 0; i < formFiles.length; ++i) {
            path[i] = this.basePath.resolve(formFiles[i]);
            String formStr = this.loadText(formFiles[i]);
            this.ioService().write(path[i], formStr, new OpenOption[0]);
        }
        Thread.sleep(5000L);
        Index index = IndexFormsTest.getConfig().getIndexManager().get(KObjectUtil.toKCluster((FileSystem)this.basePath.getFileSystem()));
        Query query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueResourceIndexTerm("PurchaseHeader.form", ResourceType.FORM)).build();
        this.searchFor(index, query, 1, new Path[]{path[2]});
        query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueReferenceIndexTerm(PurchaseOrderHeader.class.getCanonicalName(), ResourceType.JAVA)).build();
        this.searchFor(index, query, 7, new Path[]{path[0], path[1], path[2], path[5], path[6], path[7], path[8]});
        query = new SingleTermQueryBuilder((ValueIndexTerm)new ValuePartReferenceIndexTerm(PurchaseOrderHeader.class.getCanonicalName(), "customer", PartType.FIELD)).build();
        this.searchFor(index, query, 1, new Path[]{path[2]});
        query = new SingleTermQueryBuilder((ValueIndexTerm)new ValuePartReferenceIndexTerm(PurchaseOrderHeader.class.getCanonicalName(), "id", PartType.FIELD)).build();
        this.searchFor(index, query, 0, new Path[0]);
        query = new SingleTermQueryBuilder((ValueIndexTerm)new ValueReferenceIndexTerm("PurchaseHeader.form", ResourceType.FORM)).build();
        this.searchFor(index, query, 6, new Path[]{path[0], path[1], path[5], path[6], path[7], path[8]});
    }

    protected TestIndexer<FormResourceTypeDefinition> getIndexer() {
        return new TestFormIndexer((FormSerializationManager)new TestFormSerializationManagerImpl());
    }

    protected FormResourceTypeDefinition getResourceTypeDefinition() {
        return new FormResourceTypeDefinition();
    }

    protected String getRepositoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    static {
        ((FieldTypeManagerImpl)testFieldTypeManager).init();
    }

    private static class MockEmptyInstance<T>
    implements Instance<T> {
        private ArrayList<T> instances = new ArrayList(1);

        @SafeVarargs
        public MockEmptyInstance(T ... addInstances) {
            this.instances.addAll(Arrays.asList(addInstances));
        }

        public Iterator<T> iterator() {
            return this.instances.iterator();
        }

        public T get() {
            return this.instances.get(0);
        }

        public Instance<T> select(Annotation ... qualifiers) {
            return null;
        }

        public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
            return null;
        }

        public boolean isUnsatisfied() {
            return false;
        }

        public boolean isAmbiguous() {
            return false;
        }

        public void destroy(T instance) {
        }
    }

    public class TestFormSerializationManagerImpl
    extends FormSerializationManagerImpl {
        public TestFormSerializationManagerImpl() {
            this.formManager = new FormManagerImpl();
            this.fieldTypeManager = testFieldTypeManager;
            final DataModelerService dataModelerService = (DataModelerService)Mockito.spy((Object)new DataModelerService(){
                {
                    this.ioService = IndexFormsTest.this.ioService();
                    this.projectService = IndexFormsTest.this.getProjectService();
                    this.dataModelerService = (org.kie.workbench.common.screens.datamodeller.service.DataModelerService)Mockito.mock(org.kie.workbench.common.screens.datamodeller.service.DataModelerService.class);
                    Mockito.when((Object)this.dataModelerService.loadModel((KieProject)Matchers.any())).thenAnswer((Answer)new Answer<DataModel>(){

                        public DataModel answer(InvocationOnMock invocation) throws Throwable {
                            return new DataModelTestUtil(new DataModelerServiceImpl().getAnnotationDefinitions()).createModel(new Class[]{PurchaseOrder.class, PurchaseOrderHeader.class, PurchaseOrderLine.class});
                        }
                    });
                }

                protected Class findHolderClass(String className, String path) {
                    try {
                        return IndexFormsTest.class.getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException e) {
                        TestFormSerializationManagerImpl.this.log.warn("Unable to load class '{}': {}", (Object)className, (Object)e);
                        return null;
                    }
                }
            });
            this.dataHolderManager = new DataHolderManagerImpl(){
                {
                    this.holderBuilders = new MockEmptyInstance<DataHolderBuilder>(new PojoDataHolderBuilder(), dataModelerService);
                }
            };
            ((DataHolderManagerImpl)this.dataHolderManager).initializeHolders();
        }
    }
}

