/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.panels.modeler.backend.indexing;

import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.model.DataFieldHolder;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.FieldType;
import org.jbpm.formModeler.api.model.Form;
import org.kie.workbench.common.services.refactoring.backend.server.impact.ResourceReferenceCollector;
import org.kie.workbench.common.services.refactoring.model.index.Resource;
import org.kie.workbench.common.services.refactoring.model.index.ResourceReference;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.commons.validation.PortablePreconditions;

public class FormIndexVisitor
extends ResourceReferenceCollector {
    private final Form form;

    public FormIndexVisitor(Form form) {
        this.form = (Form)PortablePreconditions.checkNotNull((String)"form", (Object)form);
    }

    public void visit() {
        this.visit(this.form);
    }

    protected void visit(Form form) {
        Resource res = this.addResource(form.getName(), ResourceType.FORM);
        for (Field field : form.getFormFields()) {
            this.visit(field, res);
        }
        for (DataHolder dataHolder : form.getHolders()) {
            this.visit(dataHolder);
        }
    }

    protected void visit(DataHolder dataHolder) {
        String className = dataHolder.getClassName();
        ResourceReference resRef = null;
        if (className != null) {
            resRef = this.addResourceReference(dataHolder.getClassName(), ResourceType.JAVA);
            if (dataHolder.canHaveChildren()) {
                for (DataFieldHolder field : dataHolder.getFieldHolders()) {
                    if (!this.form.isFieldBinded(dataHolder, field.getId())) continue;
                    resRef.addPartReference(field.getId(), PartType.FIELD);
                    this.addResourceReference(field.getClassName(), ResourceType.JAVA);
                }
            }
        }
    }

    protected void visit(Field field, Resource res) {
        DataHolder holder = field.getForm().getDataHolderByField(field);
        res.addPart(field.getFieldName(), PartType.FORM_FIELD);
        if (holder != null) {
            int slash;
            String bindingExpression;
            String holderFieldId;
            DataFieldHolder holderField;
            if (holder.canHaveChildren() && (holderField = holder.getDataFieldHolderById(holderFieldId = (bindingExpression = (String)StringUtils.defaultIfEmpty((CharSequence)field.getInputBinding(), (CharSequence)field.getOutputBinding())).substring((slash = bindingExpression.indexOf("/")) + 1))) != null) {
                this.addResourceReference(holderField.getClassName(), ResourceType.JAVA);
            }
        } else {
            String fieldClass;
            FieldType type = field.getFieldType();
            if (type != null && (fieldClass = type.getFieldClass()) != null && !fieldClass.isEmpty()) {
                this.addResourceReference(fieldClass, ResourceType.JAVA);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)field.getDefaultSubform())) {
            this.addResourceReference(field.getDefaultSubform(), ResourceType.FORM);
        }
        if (!StringUtils.isEmpty((CharSequence)field.getPreviewSubform())) {
            this.addResourceReference(field.getDefaultSubform(), ResourceType.FORM);
        }
        if (!StringUtils.isEmpty((CharSequence)field.getTableSubform())) {
            this.addResourceReference(field.getDefaultSubform(), ResourceType.FORM);
        }
    }
}

