/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.editor.client.editors;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jbpm.formModeler.editor.client.editors.FormModelerPanelView;
import org.jbpm.formModeler.editor.client.resources.i18n.Constants;
import org.jbpm.formModeler.editor.client.type.FormDefinitionResourceType;
import org.jbpm.formModeler.editor.model.FormEditorContextTO;
import org.jbpm.formModeler.editor.model.FormModelerContent;
import org.jbpm.formModeler.editor.service.FormModelerService;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.client.resources.i18n.CommonConstants;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.ext.editor.commons.client.validation.Validator;
import org.uberfire.ext.editor.commons.service.support.SupportsDelete;
import org.uberfire.ext.editor.commons.service.support.SupportsRename;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.type.FileNameUtil;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@Dependent
@WorkbenchEditor(identifier="FormModelerEditor", supportedTypes={FormDefinitionResourceType.class})
public class FormModelerPanelPresenter
extends KieEditor {
    @Inject
    protected PlaceManager placeManager;
    @Inject
    protected Caller<FormModelerService> modelerService;
    @Inject
    protected BusyIndicatorView busyIndicatorView;
    @Inject
    protected Event<NotificationEvent> notification;
    @Inject
    protected Caller<MetadataService> metadataService;
    @Inject
    protected FormDefinitionResourceType resourceType;
    @Inject
    protected DefaultFileNameValidator fileNameValidator;
    @Inject
    protected FileMenuBuilder menuBuilder;
    protected FormModelerPanelView view;
    protected FormModelerContent content;

    @Inject
    public FormModelerPanelPresenter(FormModelerPanelView baseView) {
        super((KieEditorView)baseView);
        this.view = baseView;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        this.init(path, place, this.resourceType);
    }

    protected void loadContent() {
        if (this.versionRecordManager.getCurrentPath() != null) {
            if (this.content == null) {
                ((FormModelerService)this.modelerService.call((RemoteCallback)new RemoteCallback<FormModelerContent>(){

                    public void callback(FormModelerContent content) {
                        FormModelerPanelPresenter.this.loadContext(content);
                    }
                }, (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
            } else {
                ((FormModelerService)this.modelerService.call((RemoteCallback)new RemoteCallback<FormEditorContextTO>(){

                    public void callback(FormEditorContextTO ctx) {
                        FormModelerPanelPresenter.this.content.setContextTO(ctx);
                        FormModelerPanelPresenter.this.loadContext(FormModelerPanelPresenter.this.content);
                    }
                }, (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).reloadContent((Path)this.versionRecordManager.getCurrentPath(), this.content.getContextTO().getCtxUID());
            }
        }
    }

    public void save() {
        this.savePopUpPresenter.show((Path)this.versionRecordManager.getCurrentPath(), (ParameterizedCommand)new ParameterizedCommand<String>(){

            public void execute(String commitMessage) {
                FormModelerPanelPresenter.this.runSaveCommand(commitMessage);
            }
        });
        this.concurrentUpdateSessionInfo = null;
    }

    protected void runSaveCommand(String commitMessage) {
        this.busyIndicatorView.showBusyIndicator(CommonConstants.INSTANCE.Saving());
        try {
            ((FormModelerService)this.modelerService.call((RemoteCallback)new RemoteCallback<Path>(){

                public void callback(Path formPath) {
                    FormModelerPanelPresenter.this.busyIndicatorView.hideBusyIndicator();
                    FormModelerPanelPresenter.this.notification.fire((Object)new NotificationEvent(Constants.INSTANCE.form_modeler_successfully_saved(FormModelerPanelPresenter.this.versionRecordManager.getCurrentPath().getFileName()), NotificationEvent.NotificationType.SUCCESS));
                    FormModelerPanelPresenter.this.versionRecordManager.reloadVersions((Path)FormModelerPanelPresenter.this.versionRecordManager.getCurrentPath());
                }
            })).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.content.getContextTO(), this.metadata, commitMessage);
        }
        catch (Exception e) {
            this.notification.fire((Object)new NotificationEvent(Constants.INSTANCE.form_modeler_cannot_save(this.versionRecordManager.getCurrentPath().getFileName()), NotificationEvent.NotificationType.ERROR));
        }
        finally {
            this.busyIndicatorView.hideBusyIndicator();
        }
    }

    protected Caller<? extends SupportsDelete> getDeleteServiceCaller() {
        return this.modelerService;
    }

    protected Caller<? extends SupportsRename> getRenameServiceCaller() {
        return this.modelerService;
    }

    @OnClose
    public void onClose() {
        if (this.content != null) {
            ((FormModelerService)this.modelerService.call()).removeEditingForm(this.content.getContextTO().getCtxUID());
        }
    }

    public void loadContext(FormModelerContent content) {
        this.busyIndicatorView.hideBusyIndicator();
        this.content = content;
        this.resetEditorPages(content.getOverview());
        if (content.getContextTO().isLoadError()) {
            this.notification.fire((Object)new NotificationEvent(Constants.INSTANCE.form_modeler_cannot_load_form(content.getPath().getFileName()), NotificationEvent.NotificationType.ERROR));
        }
        this.view.loadContext(content.getContextTO().getCtxUID());
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        String fileName = FileNameUtil.removeExtension((Path)this.versionRecordManager.getCurrentPath(), (ResourceTypeDefinition)this.resourceType);
        return Constants.INSTANCE.form_modeler_title(fileName);
    }

    @WorkbenchMenu
    public Menus getMenus() {
        if (this.menus == null) {
            this.makeMenuBar();
        }
        return this.menus;
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    protected void makeMenuBar() {
        this.menus = this.menuBuilder.addSave(this.versionRecordManager.newSaveMenuItem(new Command(){

            public void execute() {
                FormModelerPanelPresenter.this.onSave();
            }
        })).addCopy((Path)this.versionRecordManager.getCurrentPath(), (Validator)this.fileNameValidator).addRename((Path)this.versionRecordManager.getPathToLatest(), (Validator)this.fileNameValidator).addDelete((Path)this.versionRecordManager.getPathToLatest()).addNewTopLevelMenu(this.versionRecordManager.buildMenu()).build();
    }
}

