/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.components;

import java.text.MessageFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.apache.commons.lang.StringEscapeUtils;

public class FactoryURL {
    public static final String SCHEMA = "factory";
    public static final String NAME_FORMAT = "factory://{0}/{1}";
    protected static final MessageFormat msgf = new MessageFormat("factory://{0}/{1}");
    public static final String PARAMETER_BEAN = "_fb";
    public static final String PARAMETER_PROPERTY = "_fp";
    public static final String DISPATCH_ACTION = "pAction";
    private String componentName;
    private String propertyName;

    public FactoryURL(String componentName, String propertyName) {
        this.componentName = componentName;
        this.propertyName = propertyName;
    }

    public static FactoryURL getURL(String value) throws ParseException {
        ParsePosition pPos = new ParsePosition(0);
        Object[] o = msgf.parse(value, pPos);
        if (o == null) {
            throw new ParseException("Cannot parse " + value + ". Error at position " + pPos.getErrorIndex(), pPos.getErrorIndex());
        }
        String componentName = StringEscapeUtils.unescapeHtml((String)((String)o[0]));
        String propertyName = StringEscapeUtils.unescapeHtml((String)((String)o[1]));
        return new FactoryURL(componentName, propertyName);
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(SCHEMA);
        sb.append("://");
        sb.append(StringEscapeUtils.escapeHtml((String)this.componentName));
        sb.append("/");
        sb.append(StringEscapeUtils.escapeHtml((String)this.propertyName));
        return sb.toString();
    }
}

