/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.jbpm.formModeler.service.error.ErrorManager;
import org.jbpm.formModeler.service.error.ErrorReport;
import org.jbpm.formModeler.service.error.ErrorReportHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSPIncludeTag
extends TagSupport {
    private static transient Logger log = LoggerFactory.getLogger((String)JSPIncludeTag.class.getName());
    protected String page = null;
    protected Boolean flush = false;
    protected String errorPage = "/formModeler/error.jsp";

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    public Boolean getFlush() {
        return this.flush;
    }

    public void setFlush(Boolean flush) {
        this.flush = flush;
    }

    public int doStartTag() throws JspException {
        try {
            this.pageContext.include(this.page);
        }
        catch (Throwable t) {
            this.handleError(t);
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    protected void handleError(Throwable t) {
        ErrorReport errorReport = ErrorManager.lookup().notifyError(t, true);
        try {
            ErrorReportHandler errorHandler = ErrorReportHandler.lookup();
            errorHandler.setErrorReport(errorReport);
            errorHandler.setCloseEnabled(false);
            this.pageContext.getRequest().setAttribute("errorHandlerName", (Object)"org.jbpm.formModeler.service.error.JSPIncludeErrorHandler");
            this.pageContext.include(this.errorPage);
        }
        catch (Throwable t1) {
            log.error("JSP error processing failed.", t1);
            try {
                String errorStr = errorReport.printErrorMessage() + "\n\n" + errorReport.printContext(0);
                this.pageContext.getOut().println("<span class=\"skn-error\"><pre>" + errorStr + "</pre></span>");
            }
            catch (Throwable t2) {
                log.error("Cannot print a JSP error message.", t2);
            }
        }
    }
}

