/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.error;

import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.formModeler.service.annotation.config.Config;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.Formatter;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;
import org.jbpm.formModeler.service.error.BusinessError;
import org.jbpm.formModeler.service.error.ErrorManager;
import org.jbpm.formModeler.service.error.ErrorReport;
import org.jbpm.formModeler.service.error.ErrorReportHandler;

@Named(value="ErrorReportFormatter")
public class ErrorReportFormatter
extends Formatter {
    @Inject
    @Config(value="/formModeler/components/errorReport/images/32x32/info.gif")
    protected String messagesImg;
    @Inject
    @Config(value="/formModeler/components/errorReport/images/32x32/warning.gif")
    protected String warningsImg;
    @Inject
    @Config(value="/formModeler/components/errorReport/images/32x32/error.gif")
    protected String errorsImg;

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
        ErrorReportHandler errorReportHandler = ErrorReportHandler.lookup();
        ErrorReport errorReport = errorReportHandler.getErrorReport();
        if (errorReport != null) {
            this.setAttribute("errorIcon", this.getErrorIcon(errorReport));
            this.setAttribute("errorMessage", errorReport.printErrorMessage());
            this.setAttribute("closeEnabled", errorReportHandler.isCloseEnabled());
            if (!errorReport.isBusinessAppError()) {
                this.setAttribute("technicalDetails", errorReport.printContext(0));
            }
            this.renderFragment("errorMessage");
        }
    }

    protected String getErrorIcon(ErrorReport errorReport) {
        if (errorReport.isBusinessAppError()) {
            BusinessError appError = (BusinessError)ErrorManager.lookup().getApplicationErrorCause(errorReport.getException());
            switch (appError.getLevel()) {
                case 0: {
                    return this.errorsImg;
                }
                case 1: {
                    return this.warningsImg;
                }
                case 2: {
                    return this.messagesImg;
                }
            }
        }
        return this.errorsImg;
    }
}

