/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.components.handling;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.service.bb.mvc.components.CurrentComponentRenderer;
import org.jbpm.formModeler.service.bb.mvc.components.FactoryURL;
import org.jbpm.formModeler.service.bb.mvc.components.handling.FieldException;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.SendStreamResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.ShowScreenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanHandler
implements Serializable {
    private Logger log = LoggerFactory.getLogger(BeanHandler.class);
    private List propertyErrors = new ArrayList();
    private Set wrongFields = new HashSet();
    private Properties actionsShortcuts = new Properties();
    private Properties reverseActionsShortcuts = new Properties();
    private boolean useActionShortcuts = true;
    private boolean enableDoubleClickControl = true;
    private boolean enabledForActionHandling = false;
    private Map<String, String> extraActionParams = new HashMap<String, String>();

    public String getBeanName() {
        return this.getClass().getName();
    }

    public boolean isUseActionShortcuts() {
        return this.useActionShortcuts;
    }

    public void setUseActionShortcuts(boolean useActionShortcuts) {
        this.useActionShortcuts = useActionShortcuts;
    }

    public boolean isEnableDoubleClickControl() {
        return this.enableDoubleClickControl;
    }

    public void setEnableDoubleClickControl(boolean enableDoubleClickControl) {
        this.enableDoubleClickControl = enableDoubleClickControl;
    }

    public boolean isEnabledForActionHandling() {
        return this.enabledForActionHandling;
    }

    public void setEnabledForActionHandling(boolean enabledForActionHandling) {
        this.enabledForActionHandling = enabledForActionHandling;
    }

    @PostConstruct
    public void start() throws Exception {
        if (this.isUseActionShortcuts()) {
            this.calculateActionShortcuts();
        }
    }

    protected void calculateActionShortcuts() {
        Method[] allMethods = this.getClass().getMethods();
        TreeSet<String> actionNames = new TreeSet<String>();
        for (int i = 0; i < allMethods.length; ++i) {
            Class<?> paramClass;
            Class<?>[] classes;
            Method method = allMethods[i];
            if (!method.getName().startsWith("action") || (classes = method.getParameterTypes()) == null || classes.length != 1 || !(paramClass = classes[0]).equals(CommandRequest.class)) continue;
            String actionName = method.getName().substring("action".length());
            actionNames.add(actionName);
        }
        int index = 0;
        for (String action : actionNames) {
            this.actionsShortcuts.put(action, String.valueOf(index));
            this.reverseActionsShortcuts.put(String.valueOf(index), action);
            ++index;
        }
    }

    public String getActionName(String actionName) {
        actionName = StringUtils.capitalize((String)actionName);
        return this.actionsShortcuts.getProperty(actionName, actionName);
    }

    public String getActionForShortcut(String shortcut) {
        String actionName = this.reverseActionsShortcuts.getProperty(shortcut);
        return actionName != null ? actionName : shortcut;
    }

    public synchronized CommandResponse handle(CommandRequest request, String action) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entering handle " + this.getBeanName() + " action: " + action);
        }
        action = StringUtils.capitalize((String)action);
        action = this.reverseActionsShortcuts.getProperty(action, action);
        if (this.isEnableDoubleClickControl() && !this.isEnabledForActionHandling()) {
            this.log.warn("Discarding duplicated execution in component " + this.getBeanName() + ", action: " + action + ". User should be advised not to double click!");
            return null;
        }
        try {
            String methodName = "action" + action;
            this.beforeInvokeAction(request, action);
            CommandResponse response = null;
            Method handlerMethod = this.getClass().getMethod(methodName, CommandRequest.class);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Invoking method " + methodName + " on " + this.getBeanName());
            }
            response = (CommandResponse)handlerMethod.invoke((Object)this, request);
            this.afterInvokeAction(request, action);
            if (response == null) {
                response = new ShowScreenResponse(CurrentComponentRenderer.lookup().getCurrentComponent().getBaseComponentJSP());
            }
            if (!(response instanceof SendStreamResponse)) {
                this.setEnabledForActionHandling(false);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Leaving handle " + this.getBeanName() + " - " + action);
            }
            return response;
        }
        catch (Exception ex) {
            this.log.warn("Error handling action '" + action + "': ", (Throwable)ex);
            return null;
        }
    }

    protected void beforeInvokeAction(CommandRequest request, String action) throws Exception {
    }

    protected void afterInvokeAction(CommandRequest request, String action) throws Exception {
    }

    public void addFieldError(FactoryURL property, Exception e, Object propertyValue) {
        this.propertyErrors.add(new FieldException("Error setting property to component", property, propertyValue, e));
        this.wrongFields.add(property.getPropertyName());
    }

    public void clearFieldErrors() {
        this.propertyErrors.clear();
        this.wrongFields.clear();
    }

    public List getFieldErrors() {
        return Collections.unmodifiableList(this.propertyErrors);
    }

    public boolean hasError(String fieldName) {
        return this.wrongFields.contains(fieldName);
    }

    public void actionVoid(CommandRequest request) {
    }

    public Map<String, String> getExtraActionParams() {
        return this.extraActionParams;
    }
}

