/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.controller.requestChain;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.HTTPSettings;
import org.jbpm.formModeler.service.bb.mvc.controller.requestChain.RequestChainProcessor;

public class ResponseHeadersProcessor
implements RequestChainProcessor {
    private boolean useRefreshHeader = false;
    private String responseContentType = "text/html";

    @Override
    public boolean processRequest(CommandRequest request) {
        HttpServletResponse response = request.getResponseObject();
        if (this.responseContentType != null && !"".equals(this.responseContentType)) {
            response.setContentType(this.responseContentType);
            response.setHeader("Content-Type", this.responseContentType + "; charset=" + HTTPSettings.lookup().getEncoding());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US);
        response.setHeader("Expires", "Mon, 06 Jan 2003 21:29:02 GMT");
        response.setHeader("Last-Modified", sdf.format(new Date()) + " GMT");
        response.setHeader("Cache-Control", "no-cache, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        if (this.useRefreshHeader) {
            response.setHeader("Refresh", String.valueOf(request.getSessionObject().getMaxInactiveInterval() + 61));
        }
        return true;
    }
}

