/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.taglib.formatter;

import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.Formatter;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="TemplateFormatter")
public class TemplateFormatter
extends Formatter {
    private static transient Logger log = LoggerFactory.getLogger((String)TemplateFormatter.class.getName());
    private String fragmentStart = "{";
    private String fragmentEnd = "}";

    public String getFragmentStart() {
        return this.fragmentStart;
    }

    public void setFragmentStart(String fragmentStart) {
        this.fragmentStart = fragmentStart;
    }

    public String getFragmentEnd() {
        return this.fragmentEnd;
    }

    public void setFragmentEnd(String fragmentEnd) {
        this.fragmentEnd = fragmentEnd;
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
        String template = (String)this.getParameter("template");
        if (StringUtils.isEmpty((CharSequence)template)) {
            this.handleEmptyTemplate();
        } else {
            this.processTemplate(template);
        }
    }

    protected void processTemplate(String template) {
        int firstStartingDelimiter = template.indexOf(this.fragmentStart);
        int firstEndingDelimiter = template.indexOf(this.fragmentEnd, firstStartingDelimiter);
        if (firstStartingDelimiter == -1 || firstEndingDelimiter == -1) {
            this.writeToOut(template);
        } else {
            String textBefore = template.substring(0, firstStartingDelimiter);
            String fragmentName = template.substring(firstStartingDelimiter + 1, firstEndingDelimiter);
            String textAfter = template.substring(firstEndingDelimiter + 1, template.length());
            if (StringUtils.isEmpty((CharSequence)fragmentName)) {
                this.writeToOut(textBefore);
                this.writeToOut(this.fragmentStart);
                this.writeToOut(this.fragmentEnd);
            } else {
                this.writeToOut(textBefore);
                this.includeFragment(fragmentName);
            }
            this.processTemplate(textAfter);
        }
    }

    protected void includeFragment(String fragmentName) {
        this.setAttributesForFragment(fragmentName);
        this.renderFragment(fragmentName);
    }

    protected void setAttributesForFragment(String fragmentName) {
    }

    protected void handleEmptyTemplate() {
    }
}

