/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.components.handling;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.jbpm.formModeler.service.LocaleManager;
import org.jbpm.formModeler.service.annotation.config.Config;
import org.jbpm.formModeler.service.bb.mvc.components.PanelComponent;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

@ApplicationScoped
@Named(value="msghandler")
public class MessagesComponentHandler
extends PanelComponent {
    @Inject
    @Config(value="600")
    protected int width;
    @Inject
    @Config(value="200")
    protected int height;
    @Inject
    @Config(value="/formModeler/components/messages/show.jsp")
    protected String componentIncludeJSP;
    @Inject
    @Config(value="true")
    private boolean clearAfterRender = true;
    @Inject
    @Config(value="org.jbpm.formModeler.core.processing.formRendering.messages")
    private String i18nBundle;
    private List messagesToDisplay = new ArrayList();
    private List warningsToDisplay = new ArrayList();
    private List errorsToDisplay = new ArrayList();
    private List messagesParameters = new ArrayList();
    private List warningsParameters = new ArrayList();
    private List errorsParameters = new ArrayList();

    public static MessagesComponentHandler lookup() {
        return (MessagesComponentHandler)CDIBeanLocator.getBeanByType(MessagesComponentHandler.class);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public List getMessagesToDisplay() {
        return this.messagesToDisplay;
    }

    public void setMessagesToDisplay(List messagesToDisplay) {
        this.messagesToDisplay = messagesToDisplay;
    }

    public List getWarningsToDisplay() {
        return this.warningsToDisplay;
    }

    public void setWarningsToDisplay(List warningsToDisplay) {
        this.warningsToDisplay = warningsToDisplay;
    }

    public List getErrorsToDisplay() {
        return this.errorsToDisplay;
    }

    public void setErrorsToDisplay(List errorsToDisplay) {
        this.errorsToDisplay = errorsToDisplay;
    }

    public List getMessagesParameters() {
        return this.messagesParameters;
    }

    public void setMessagesParameters(List messagesParameters) {
        this.messagesParameters = messagesParameters;
    }

    public List getWarningsParameters() {
        return this.warningsParameters;
    }

    public void setWarningsParameters(List warningsParameters) {
        this.warningsParameters = warningsParameters;
    }

    public List getErrorsParameters() {
        return this.errorsParameters;
    }

    public void setErrorsParameters(List errorsParameters) {
        this.errorsParameters = errorsParameters;
    }

    @Override
    public String getBeanJSP() {
        return this.componentIncludeJSP;
    }

    public void setComponentIncludeJSP(String componentIncludeJSP) {
        this.componentIncludeJSP = componentIncludeJSP;
    }

    public String getI18nBundle() {
        return this.i18nBundle;
    }

    public void setI18nBundle(String i18nBundle) {
        this.i18nBundle = i18nBundle;
    }

    public boolean isClearAfterRender() {
        return this.clearAfterRender;
    }

    public void setClearAfterRender(boolean clearAfterRender) {
        this.clearAfterRender = clearAfterRender;
    }

    public void clearAll() {
        this.messagesToDisplay.clear();
        this.warningsToDisplay.clear();
        this.errorsToDisplay.clear();
        this.messagesParameters.clear();
        this.warningsToDisplay.clear();
        this.errorsToDisplay.clear();
    }

    public void addMessage(String message) {
        this.addMessage(message, null);
    }

    public void addWarning(String message) {
        this.addWarning(message, null);
    }

    public void addError(String message) {
        this.addError(message, null);
    }

    public void addMessage(String message, String[] params) {
        if (this.isValidMessage(message)) {
            this.messagesToDisplay.add(message);
            this.messagesParameters.add(params);
        }
    }

    public void addWarning(String message, String[] params) {
        if (this.isValidMessage(message)) {
            this.warningsToDisplay.add(message);
            this.warningsParameters.add(params);
        }
    }

    public void addError(String message, String[] params) {
        if (this.isValidMessage(message)) {
            this.errorsToDisplay.add(message);
            this.errorsParameters.add(params);
        }
    }

    protected boolean isValidMessage(String message) {
        return message != null && !"".equals(message);
    }

    public void addMessageFromBundle(String bundle, String key) {
        this.addMessage(this.getStringFromBundle(bundle, key));
    }

    public void addWarningFromBundle(String bundle, String key) {
        this.addWarning(this.getStringFromBundle(bundle, key));
    }

    public void addErrorFromBundle(String bundle, String key) {
        this.addError(this.getStringFromBundle(bundle, key));
    }

    protected String getStringFromBundle(String bundle, String key) {
        ResourceBundle rb = ResourceBundle.getBundle(bundle, LocaleManager.currentLocale());
        return rb.getString(key);
    }
}

