/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.controller;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.RequestMultipartWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandRequestImpl
implements CommandRequest {
    private HttpServletRequest req = null;
    private HttpServletResponse res = null;
    private Map filesByParamName;
    private static Logger log = LoggerFactory.getLogger((String)CommandRequestImpl.class.getName());

    public CommandRequestImpl(HttpServletRequest req, HttpServletResponse res) {
        this.req = req;
        this.res = res;
        this.buildFiles();
    }

    private void buildFiles() {
        try {
            RequestMultipartWrapper wrap;
            Enumeration en;
            if (this.req instanceof RequestMultipartWrapper && (en = (wrap = (RequestMultipartWrapper)this.req).getFileParameterNames()) != null && en.hasMoreElements()) {
                this.filesByParamName = new HashMap();
                while (en.hasMoreElements()) {
                    String name = (String)en.nextElement();
                    File file = wrap.getUploadedFile(name);
                    if (file == null) continue;
                    this.filesByParamName.put(name, file);
                    log.debug("Found file " + file.getName() + " in " + file.getAbsoluteFile());
                }
            }
        }
        catch (Exception e) {
            log.error("Error building files", (Throwable)e);
        }
    }

    @Override
    public HttpServletRequest getRequestObject() {
        return this.req;
    }

    @Override
    public Set getParameterNames() {
        HashSet s = new HashSet();
        Enumeration en = this.getRequestObject().getParameterNames();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            s.add(o);
        }
        return s;
    }

    @Override
    public HttpServletResponse getResponseObject() {
        return this.res;
    }

    @Override
    public Map getFilesByParamName() {
        return this.filesByParamName == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(this.filesByParamName);
    }

    @Override
    public String getParameter(String name) {
        return this.getRequestObject().getParameter(name);
    }

    @Override
    public int getUploadedFilesCount() {
        return this.filesByParamName != null ? this.filesByParamName.size() : 0;
    }

    @Override
    public HttpSession getSessionObject() {
        return this.getRequestObject().getSession();
    }
}

