/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.controller.requestChain;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jbpm.formModeler.service.bb.mvc.components.ControllerStatus;
import org.jbpm.formModeler.service.bb.mvc.components.URLMarkupGenerator;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.ControllerServletHelper;
import org.jbpm.formModeler.service.bb.mvc.controller.HTTPSettings;
import org.jbpm.formModeler.service.bb.mvc.controller.RequestMultipartWrapper;
import org.jbpm.formModeler.service.bb.mvc.controller.SessionTmpDirFactory;
import org.jbpm.formModeler.service.bb.mvc.controller.requestChain.RequestChainProcessor;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.RedirectToURLResponse;
import org.jbpm.formModeler.service.bb.mvc.taglib.ContextTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartProcessor
implements RequestChainProcessor {
    private static transient Logger log = LoggerFactory.getLogger(MultipartProcessor.class);
    private String errorRedirectPage = "/formModeler/fileTooBig.jsp";

    @Override
    public boolean processRequest(CommandRequest request) throws Exception {
        HTTPSettings httpSettings = HTTPSettings.lookup();
        HttpServletRequest httpReq = request.getRequestObject();
        HttpServletResponse httpRes = request.getResponseObject();
        String contentType = httpReq.getContentType();
        String method = httpReq.getMethod();
        if ("POST".equalsIgnoreCase(method) && contentType != null && contentType.startsWith("multipart") && httpSettings.isMultipartProcessing()) {
            log.debug("Found multipart request. Building wrapper");
            String tmpDir = SessionTmpDirFactory.getTmpDir(httpReq);
            if (log.isDebugEnabled()) {
                log.debug("Extracting to dir " + tmpDir);
            }
            int maxSize = httpSettings.getMaxPostSize() * 1024;
            if (log.isDebugEnabled()) {
                log.debug("Max post size is : " + maxSize + " bytes");
                log.debug("Framework encoding is: " + httpSettings.getEncoding());
            }
            try {
                RequestMultipartWrapper wrap = new RequestMultipartWrapper(httpReq, tmpDir, maxSize, httpSettings.getEncoding());
                log.debug("Multipart request parsed: ");
                log.debug("getting files from request");
                ControllerServletHelper.lookup().initThreadLocal((HttpServletRequest)wrap, httpRes);
            }
            catch (IOException ioe) {
                log.warn("IOException processing multipart ", (Throwable)ioe);
                log.warn("Invalid " + method + ": URL=" + httpReq.getRequestURL() + ". QueryString=" + httpReq.getQueryString());
                URLMarkupGenerator markupGenerator = URLMarkupGenerator.lookup();
                if (markupGenerator != null) {
                    HashMap<String, String> paramsMap = new HashMap<String, String>();
                    paramsMap.put("JB_page_to_redirect", this.errorRedirectPage);
                    String uri = ContextTag.getContextPath(markupGenerator.getMarkup("org.jbpm.formModeler.service.mvc.components.RedirectionHandler", "redirectToSection", paramsMap), httpReq);
                    uri = StringEscapeUtils.unescapeHtml4((String)uri);
                    ControllerStatus.lookup().setResponse(new RedirectToURLResponse(uri, !uri.startsWith(httpReq.getContextPath())));
                }
                return false;
            }
        }
        return true;
    }
}

