/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.components.handling;

import javax.servlet.http.HttpServletRequest;
import org.jbpm.formModeler.service.bb.mvc.components.CurrentComponentRenderer;
import org.jbpm.formModeler.service.bb.mvc.components.handling.BaseUIComponent;
import org.jbpm.formModeler.service.bb.mvc.components.handling.BeanHandler;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.SendStreamResponse;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class AbstractBeanHandlerTest<T extends BeanHandler> {
    protected CommandRequest request;
    protected HttpServletRequest httpServletRequest;
    protected CurrentComponentRenderer renderer;
    protected BaseUIComponent component;
    protected T handlerComponent;

    public abstract T getHandlerComponent();

    protected void initTest(boolean isAjax) {
        this.renderer = (CurrentComponentRenderer)Mockito.mock(CurrentComponentRenderer.class);
        this.component = (BaseUIComponent)Mockito.mock(BaseUIComponent.class);
        Mockito.when((Object)this.component.getBaseComponentJSP()).thenReturn((Object)"/test/myComponent.jsp");
        Mockito.when((Object)this.renderer.getCurrentComponent()).thenReturn((Object)this.component);
        this.handlerComponent = this.getHandlerComponent();
        this.request = (CommandRequest)Mockito.mock(CommandRequest.class);
        this.httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)this.request.getRequestObject()).thenReturn((Object)this.httpServletRequest);
        Mockito.when((Object)this.httpServletRequest.getParameter("ajaxAction")).thenReturn((Object)(isAjax ? "true" : "false"));
    }

    @Test
    public void testDefaultAjaxActionWithResponse() throws Exception {
        this.initTest(true);
        CommandResponse response = this.handlerComponent.handle(this.request, "withResponse");
        ((CommandRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.atLeastOnce())).getRequestObject();
        ((HttpServletRequest)Mockito.verify((Object)this.httpServletRequest)).getParameter("ajaxAction");
        Assert.assertNotNull((String)"Response cannot be null", (Object)response);
    }

    @Test
    public void testDefaultNonAjaxActionWithResponse() throws Exception {
        this.initTest(false);
        CommandResponse response = this.handlerComponent.handle(this.request, "withResponse");
        ((CommandRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.atLeastOnce())).getRequestObject();
        ((HttpServletRequest)Mockito.verify((Object)this.httpServletRequest)).getParameter("ajaxAction");
        Assert.assertNull((String)"Response must be null", (Object)response);
    }

    @Test
    public void testDefaultAjaxActionWithoutResponse() throws Exception {
        this.initTest(true);
        CommandResponse response = this.handlerComponent.handle(this.request, "withoutResponse");
        ((CommandRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.atLeastOnce())).getRequestObject();
        ((HttpServletRequest)Mockito.verify((Object)this.httpServletRequest)).getParameter("ajaxAction");
        Assert.assertNotNull((String)"Response cannot be null", (Object)response);
    }

    @Test
    public void testDefaultNonAjaxActionWithoutResponse() throws Exception {
        this.initTest(false);
        CommandResponse response = this.handlerComponent.handle(this.request, "withoutResponse");
        ((CommandRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.atLeastOnce())).getRequestObject();
        ((HttpServletRequest)Mockito.verify((Object)this.httpServletRequest)).getParameter("ajaxAction");
        Assert.assertNull((String)"Response be null", (Object)response);
    }

    @Test
    public void testActionWithStreamResponse() throws Exception {
        this.doTestActionWithStreamResponse(true);
        this.doTestActionWithStreamResponse(false);
    }

    protected void doTestActionWithStreamResponse(boolean ajax) throws Exception {
        this.initTest(true);
        CommandResponse response = this.handlerComponent.handle(this.request, "download");
        ((CommandRequest)Mockito.verify((Object)this.request, (VerificationMode)Mockito.never())).getRequestObject();
        ((HttpServletRequest)Mockito.verify((Object)this.httpServletRequest, (VerificationMode)Mockito.never())).getParameter("ajaxAction");
        Assert.assertNotNull((String)"Response cannot be null", (Object)response);
        Assert.assertTrue((String)"Response must be SendStreamResponse", (boolean)(response instanceof SendStreamResponse));
    }
}

