/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.service.bb.mvc.taglib.formatter;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.jxpath.JXPathContext;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.ForComparator;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.Formatter;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="org.jbpm.formModeler.service.mvc.formatters.ForFormatter")
public class ForFormatter
extends Formatter {
    private Logger log = LoggerFactory.getLogger(ForFormatter.class);

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
        this.log.debug("Servicing ForFormatter.");
        Object array = this.getParameter("array");
        if (array == null) {
            Object componentName = this.getParameter("bean");
            Object propertyName = this.getParameter("property");
            if (componentName != null) {
                Object component;
                array = component = CDIBeanLocator.getBeanByNameOrType((String)((String)componentName));
                if (propertyName != null) {
                    JXPathContext ctx = JXPathContext.newContext((Object)component);
                    try {
                        array = ctx.getValue((String)propertyName);
                    }
                    catch (Exception e) {
                        this.log.debug("Error:", (Throwable)e);
                    }
                }
            }
        }
        String sortProperties = (String)this.getParameter("sortProperties");
        Iterator iterator = null;
        if (array == null) {
            this.renderFragment("empty");
            return;
        }
        if (array instanceof Collection) {
            iterator = ((Collection)array).iterator();
        } else if (array.getClass().isArray()) {
            final Object theArray = array;
            iterator = new Iterator(){
                int index = 0;

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return Array.getLength(theArray) > this.index;
                }

                public Object next() {
                    return Array.get(theArray, this.index++);
                }
            };
        } else if (array instanceof Iterator) {
            iterator = (Iterator)array;
        } else if (array instanceof Enumeration) {
            ArrayList l = new ArrayList();
            while (((Enumeration)array).hasMoreElements()) {
                l.add(((Enumeration)array).nextElement());
            }
            iterator = l.iterator();
        }
        if (sortProperties != null) {
            iterator = this.getSortedIterator(iterator, sortProperties);
        }
        if (iterator != null && iterator.hasNext()) {
            this.renderFragment("outputStart");
            int i = 0;
            while (iterator.hasNext()) {
                Object o = iterator.next();
                this.setAttribute("index", new Integer(i));
                this.setAttribute("count", new Integer(++i));
                if (o != null) {
                    this.setAttribute("element", o);
                } else {
                    this.setAttribute("element", this.getParameter("nullValue"));
                }
                this.renderFragment("output");
            }
            this.renderFragment("outputEnd");
        } else {
            this.renderFragment("empty");
        }
    }

    protected Iterator getSortedIterator(Iterator iterator, String sortProperties) {
        ArrayList l = new ArrayList();
        while (iterator.hasNext()) {
            l.add(iterator.next());
        }
        Collections.sort(l, new ForComparator(sortProperties));
        return l.iterator();
    }

    public void shutdown() {
        this.log.debug("Shutting down ForFormatter.");
    }

    public void init() {
        this.log.debug("Starting up ForFormatter.");
    }
}

