/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.server.impl;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.util.Version;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.RuleAttributeNameAnalyzer;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfig;
import org.uberfire.ext.metadata.backend.lucene.LuceneConfigBuilder;
import org.uberfire.ext.metadata.backend.lucene.analyzer.FilenameAnalyzer;

@ApplicationScoped
public class LuceneConfigProducer {
    private LuceneConfig config;

    @PostConstruct
    public void setup() {
        Map<String, Analyzer> analyzers = this.getAnalyzers();
        this.config = new LuceneConfigBuilder().withInMemoryMetaModelStore().usingAnalyzers(analyzers).useDirectoryBasedIndex().useNIODirectory().build();
    }

    @Produces
    @Named(value="luceneConfig")
    public LuceneConfig configProducer() {
        return this.config;
    }

    private Map<String, Analyzer> getAnalyzers() {
        return new HashMap<String, Analyzer>(){
            {
                this.put("ruleName", new RuleAttributeNameAnalyzer(Version.LUCENE_40));
                this.put("projectRoot", new FilenameAnalyzer(Version.LUCENE_40));
            }
        };
    }
}

