/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.client;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.List;
import org.guvnor.common.services.shared.config.AppConfigService;
import org.jbpm.formModeler.client.ShowcaseEntryPoint;
import org.jbpm.formModeler.client.i18n.Constants;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.workbench.client.menu.DefaultWorkbenchFeaturesMenusHelper;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.uberfire.client.mvp.AbstractWorkbenchPerspectiveActivity;
import org.uberfire.client.mvp.ActivityBeansCache;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarPresenter;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.ConstantsAnswerMock;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@RunWith(value=GwtMockitoTestRunner.class)
public class ShowcaseEntryPointTest {
    @Mock
    private AppConfigService appConfigService;
    private CallerMock<AppConfigService> appConfigServiceCallerMock;
    @Mock
    private ActivityBeansCache activityBeansCache;
    @Mock
    private DefaultWorkbenchFeaturesMenusHelper menusHelper;
    @Mock
    private WorkbenchMenuBarPresenter menuBar;
    @Mock
    private PlaceManager placeManager;
    private ShowcaseEntryPoint showcaseEntryPoint;

    @Before
    public void setup() {
        this.appConfigServiceCallerMock = new CallerMock((Object)this.appConfigService);
        this.showcaseEntryPoint = (ShowcaseEntryPoint)Mockito.spy((Object)new ShowcaseEntryPoint(this.appConfigServiceCallerMock, this.activityBeansCache, this.menusHelper, this.menuBar, this.placeManager));
        this.mockMenuHelper();
        this.mockConstants();
    }

    @Test
    public void setupMenuTest() {
        this.showcaseEntryPoint.setupMenu();
        ArgumentCaptor menusCaptor = ArgumentCaptor.forClass(Menus.class);
        ((WorkbenchMenuBarPresenter)Mockito.verify((Object)this.menuBar)).addMenus((Menus)menusCaptor.capture());
        Menus menus = (Menus)menusCaptor.getValue();
        Assert.assertEquals((long)2L, (long)menus.getItems().size());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.home(), (Object)((MenuItem)menus.getItems().get(0)).getCaption());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.authoring(), (Object)((MenuItem)menus.getItems().get(1)).getCaption());
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addRolesMenuItems();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addWorkbenchConfigurationMenuItem();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.verify((Object)this.menusHelper)).addUtilitiesMenuItems();
    }

    @Test
    public void getAuthoringViewsTest() {
        List authoringMenuItems = this.showcaseEntryPoint.getAuthoringViews();
        Assert.assertEquals((long)1L, (long)authoringMenuItems.size());
        Assert.assertEquals((Object)this.showcaseEntryPoint.constants.project_authoring(), (Object)((MenuItem)authoringMenuItems.get(0)).getCaption());
    }

    private void mockMenuHelper() {
        ArrayList<Object> menuItems = new ArrayList<Object>();
        menuItems.add(Mockito.mock(MenuItem.class));
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.doReturn(menuItems).when((Object)this.menusHelper)).getPerspectivesMenuItems();
        ((DefaultWorkbenchFeaturesMenusHelper)Mockito.doReturn((Object)Mockito.mock(AbstractWorkbenchPerspectiveActivity.class)).when((Object)this.menusHelper)).getDefaultPerspectiveActivity();
    }

    private void mockConstants() {
        this.showcaseEntryPoint.constants = (Constants)Mockito.mock(Constants.class, (Answer)new ConstantsAnswerMock());
    }
}

