/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.fieldHandlers.DateFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.service.bb.commons.config.LocaleManager;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;

public class DateFieldHandlerFormatter
extends DefaultFieldHandlerFormatter {
    private DateFieldHandler dateFieldHandler;

    public void service(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(request);
        Field field = paramsReader.getCurrentField();
        Form form = paramsReader.getCurrentForm();
        String namespace = paramsReader.getCurrentNamespace();
        Object value = paramsReader.getCurrentFieldValue();
        String fieldName = paramsReader.getCurrentFieldName();
        this.setDefaultAttributes(field, form, namespace);
        String inputPattern = this.dateFieldHandler.getDefaultPattern();
        if (!StringUtils.isEmpty((String)this.dateFieldHandler.getDefaultPatterTimeSuffix())) {
            inputPattern = inputPattern + " " + this.dateFieldHandler.getDefaultPatterTimeSuffix();
        }
        SimpleDateFormat sdf = new SimpleDateFormat(inputPattern, LocaleManager.currentLocale());
        String dateValue = "";
        if (value != null) {
            dateValue = sdf.format(value);
        }
        this.setAttribute("name", fieldName);
        this.setAttribute("value", dateValue);
        this.setAttribute("inputPattern", this.dateFieldHandler.getDefaultPattern());
        this.setAttribute("timePattern", this.dateFieldHandler.getDefaultPatterTimeSuffix());
        this.setAttribute("uid", this.getFormManager().getUniqueIdentifier(form, namespace, field, fieldName));
        this.renderFragment("output");
    }

    public DateFieldHandler getDateFieldHandler() {
        return this.dateFieldHandler;
    }

    public void setDateFieldHandler(DateFieldHandler dateFieldHandler) {
        this.dateFieldHandler = dateFieldHandler;
    }
}

