/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.FieldType;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.api.model.i18n.I18nSet;
import org.jbpm.formModeler.api.processing.BindingManager;
import org.jbpm.formModeler.api.processing.FormProcessor;
import org.jbpm.formModeler.core.config.FormManagerImpl;
import org.jbpm.formModeler.core.processing.BindingManagerImpl;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormaterTagDynamicAttributesInterpreter;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.Formatter;

public abstract class DefaultFieldHandlerFormatter
extends Formatter {
    private static transient Log log = LogFactory.getLog((String)DefaultFieldHandlerFormatter.class.getName());
    protected int defaultMaxLength = 128;
    protected int defaultSize = 25;
    private FormManagerImpl formManagerImpl;
    private FormProcessor defaultFormProcessor;

    public void start() throws Exception {
        super.start();
        this.formManagerImpl = FormManagerImpl.lookup();
    }

    public final FormManagerImpl getFormManager() {
        return this.formManagerImpl;
    }

    public final void setFormManager(FormManagerImpl formManagerImpl) {
        this.formManagerImpl = formManagerImpl;
    }

    protected void setDefaultAttributes(final Field field, final Form form, final String namespace) {
        this.setAttributeInterpreter(new FormaterTagDynamicAttributesInterpreter(){
            private BindingManager bindingManager = BindingManagerImpl.lookup();

            public Object getValueForParameter(String parameter) {
                Object value = null;
                if ("form".equals(parameter)) {
                    value = form;
                }
                if ("field".equals(parameter)) {
                    value = field;
                }
                if (form != null && "lastParameterMap".equals(parameter)) {
                    value = DefaultFieldHandlerFormatter.this.defaultFormProcessor.read(form.getId(), namespace).getCurrentInputValues();
                }
                if (field != null && "name".equals(parameter)) {
                    value = field.getFieldName();
                }
                if (field != null && form != null) {
                    try {
                        Object val;
                        FieldType fieldType = field.getFieldType();
                        if (this.bindingManager.hasProperty((Object)fieldType, parameter)) {
                            val = this.bindingManager.getPropertyValue((Object)fieldType, parameter);
                            if ((val = DefaultFieldHandlerFormatter.this.getCustomValueIfApplicable(field, parameter, val, form, namespace)) != null) {
                                value = val;
                            }
                        }
                        if (this.bindingManager.hasProperty((Object)field, parameter)) {
                            val = this.bindingManager.getPropertyValue((Object)field, parameter);
                            if ((val = DefaultFieldHandlerFormatter.this.getCustomValueIfApplicable(field, parameter, val, form, namespace)) != null && !"".equals(val)) {
                                value = val;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)("Error calculating attribute " + parameter + " for field " + field.getFieldName()));
                    }
                }
                return value;
            }
        });
    }

    protected String getUniqueIdentifier(Form form, String namespace, Field field, String fieldName) {
        return this.getFormManager().getUniqueIdentifier(form, namespace, field, fieldName);
    }

    protected Object getCustomValueIfApplicable(Field field, String propName, Object propValue, Form form, String namespace) {
        Object overridenValue;
        if ("title".equals(propName) || "label".equals(propName)) {
            if (propValue != null && propValue instanceof I18nSet) {
                String value = (String)this.getLocaleManager().localize((Map)((I18nSet)propValue));
                Object object = propValue = !"".equals(value) ? value : null;
            }
            if ("title".equals(propName)) {
                propValue = StringEscapeUtils.escapeHtml((String)StringUtils.defaultString((String)((String)propValue)));
            }
        }
        if ((overridenValue = this.defaultFormProcessor.getAttribute(form, namespace, field.getFieldName() + "." + propName)) != null) {
            propValue = overridenValue;
        }
        return propValue;
    }

    public FormProcessor getDefaultFormProcessor() {
        return this.defaultFormProcessor;
    }

    public void setDefaultFormProcessor(FormProcessor defaultFormProcessor) {
        this.defaultFormProcessor = defaultFormProcessor;
    }
}

