/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.core.processing.DefaultFieldHandler;
import org.jbpm.formModeler.core.wrappers.HTMLString;

public class HTMLTextAreaFieldHandler
extends DefaultFieldHandler {
    private static transient Log log = LogFactory.getLog((String)HTMLTextAreaFieldHandler.class.getName());
    private String pageToIncludeForRendering = "/formModeler/fieldHandlers/HTMLTextArea/input.jsp";
    private String pageToIncludeForDisplaying = "/formModeler/fieldHandlers/HTMLTextArea/show.jsp";
    private String pageToIncludeForSearching = "/formModeler/fieldHandlers/HTMLTextArea/search.jsp";

    @Override
    public String getName() {
        return this.getComponentName();
    }

    public String[] getCompatibleClassNames() {
        return new String[]{"HTMLEditor"};
    }

    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        String[] pValues = (String[])parametersMap.get(inputName);
        return pValues != null ? new HTMLString(pValues[0]) : null;
    }

    public Map getParamValue(String inputName, Object objectValue, String pattern) {
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        if (objectValue != null) {
            if (objectValue instanceof String) {
                m.put(inputName, new String[]{(String)objectValue});
            } else if (objectValue instanceof HTMLString) {
                m.put(inputName, new String[]{((HTMLString)objectValue).getValue()});
            } else {
                log.error((Object)("Unknown value type to convert to parameter: " + objectValue.getClass()));
            }
        }
        return m;
    }

    public boolean isEmpty(Object value) {
        String textContent = null;
        HTMLString html = (HTMLString)value;
        try {
            int length;
            StringReader reader = new StringReader(html.getValue().replaceAll("&nbsp;", ""));
            StringWriter sb = new StringWriter();
            char[] buffer = new char[1024];
            while ((length = reader.read(buffer)) != -1) {
                sb.write(buffer, 0, length);
            }
            ((Reader)reader).close();
            textContent = sb.toString().trim();
            sb.close();
        }
        catch (IOException e) {
            log.warn((Object)"Error: ", (Throwable)e);
        }
        return value == null || "".equals(html.getValue()) || html.getValue() == null || textContent.length() == 0;
    }

    public String getPageToIncludeForDisplaying() {
        return this.pageToIncludeForDisplaying;
    }

    public void setPageToIncludeForDisplaying(String pageToIncludeForDisplaying) {
        this.pageToIncludeForDisplaying = pageToIncludeForDisplaying;
    }

    public String getPageToIncludeForRendering() {
        return this.pageToIncludeForRendering;
    }

    public void setPageToIncludeForRendering(String pageToIncludeForRendering) {
        this.pageToIncludeForRendering = pageToIncludeForRendering;
    }

    public String getPageToIncludeForSearching() {
        return this.pageToIncludeForSearching;
    }

    public void setPageToIncludeForSearching(String pageToIncludeForSearching) {
        this.pageToIncludeForSearching = pageToIncludeForSearching;
    }

    public boolean acceptsPropertyName(String propName) {
        return true;
    }
}

