/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.i18n.I18nEntry;
import org.jbpm.formModeler.api.model.i18n.I18nSet;
import org.jbpm.formModeler.core.processing.DefaultFieldHandler;
import org.jbpm.formModeler.service.bb.commons.config.LocaleManager;

public class I18nSetFieldHandler
extends DefaultFieldHandler {
    private static transient Log log = LogFactory.getLog((String)I18nSetFieldHandler.class.getName());
    private String pageToIncludeForRendering = "/formModeler/fieldHandlers/I18nSet/input.jsp";
    private String pageToIncludeForDisplaying = "/formModeler/fieldHandlers/I18nSet/show.jsp";
    private String pageToIncludeForSearching = "/formModeler/fieldHandlers/I18nSet/search.jsp";
    private LocaleManager localeManager;

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    public String getPageToIncludeForDisplaying() {
        return this.pageToIncludeForDisplaying;
    }

    public boolean isEmpty(Object value) {
        if (value == null || ((I18nSet)value).isEmpty()) {
            return true;
        }
        if ("".equals(((I18nSet)value).getValue(this.getLocaleManager().getDefaultLang()))) {
            return true;
        }
        for (I18nEntry entry : (I18nSet)value) {
            if (entry.getValue() == null || "".equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public void setPageToIncludeForDisplaying(String pageToIncludeForDisplaying) {
        this.pageToIncludeForDisplaying = pageToIncludeForDisplaying;
    }

    public String getPageToIncludeForRendering() {
        return this.pageToIncludeForRendering;
    }

    public void setPageToIncludeForRendering(String pageToIncludeForRendering) {
        this.pageToIncludeForRendering = pageToIncludeForRendering;
    }

    public String getPageToIncludeForSearching() {
        return this.pageToIncludeForSearching;
    }

    public void setPageToIncludeForSearching(String pageToIncludeForSearching) {
        this.pageToIncludeForSearching = pageToIncludeForSearching;
    }

    public String[] getCompatibleClassNames() {
        return new String[]{"I18nText", "I18nTextArea"};
    }

    @Override
    public String getName() {
        return this.getComponentName();
    }

    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        I18nSet set = new I18nSet();
        for (String key : parametersMap.keySet()) {
            if (key.length() <= inputName.length() || !key.startsWith(inputName)) continue;
            String lang = key.substring(inputName.length() + 1);
            String value = ((String[])parametersMap.get(key))[0];
            set.setValue(lang, value);
        }
        return set.isEmpty() ? null : set;
    }

    public Map getParamValue(String inputName, Object objectValue, String pattern) {
        if (objectValue == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        I18nSet value = (I18nSet)objectValue;
        for (I18nEntry entry : value) {
            m.put(inputName + "_" + entry.getLang(), new String[]{(String)entry.getValue()});
        }
        m.put(inputName, new String[0]);
        return m;
    }

    public boolean acceptsPropertyName(String propName) {
        return true;
    }
}

