/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.core.processing.DefaultFieldHandler;
import org.jbpm.formModeler.core.validators.NumericRangeValidator;
import org.jbpm.formModeler.service.bb.commons.config.LocaleManager;

public class NumericFieldHandler
extends DefaultFieldHandler {
    public static final String NUMERIC_FROM_SUFFIX = "_from";
    public static final String NUMERIC_TO_SUFFIX = "_to";
    public static final boolean DEFAULT_MAX_VALUE = true;
    private static transient Log log = LogFactory.getLog((String)NumericFieldHandler.class.getName());
    private String pageToIncludeForRendering = "/formModeler/fieldHandlers/Numeric/input.jsp";
    private String pageToIncludeForDisplaying = "/formModeler/fieldHandlers/Numeric/show.jsp";
    private String pageToIncludeForSearching = "/formModeler/fieldHandlers/Numeric/search.jsp";

    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        String[] numberFrom = (String[])parametersMap.get(inputName + NUMERIC_FROM_SUFFIX);
        String[] numberTo = (String[])parametersMap.get(inputName + NUMERIC_TO_SUFFIX);
        if (numberFrom != null || numberTo != null) {
            Object from = null;
            try {
                from = this.getTheValue(field, numberFrom, desiredClassName);
            }
            catch (EmptyNumberException e) {
                // empty catch block
            }
            Object to = null;
            try {
                to = this.getTheValue(field, numberTo, desiredClassName);
            }
            catch (Exception e) {
                // empty catch block
            }
            return new Object[]{from, to};
        }
        String[] paramValue = (String[])parametersMap.get(inputName);
        return this.getTheValue(field, paramValue, desiredClassName);
    }

    public Object getTheValue(Field field, String[] paramValue, String desiredClassName) throws Exception {
        String rangeFormula = field.getFieldRangeFormula();
        NumericRangeValidator validator = field == null || rangeFormula == null || "".equals(rangeFormula) || rangeFormula.startsWith("=") ? null : new NumericRangeValidator(field.getFieldRangeFormula());
        if (paramValue == null || paramValue.length == 0) {
            return null;
        }
        if (desiredClassName.equals(Integer.class.getName())) {
            if (paramValue[0] == null || paramValue[0].trim().equals("")) {
                throw new EmptyNumberException();
            }
            if (validator == null || validator.isValid(Integer.decode(paramValue[0]))) {
                return Integer.decode(paramValue[0]);
            }
            log.debug((Object)"Parameter is not in the numeric range especified");
            throw new IllegalArgumentException("Parameter is not in the numeric range especified");
        }
        if (desiredClassName.equals(Long.class.getName())) {
            if (paramValue[0] == null || paramValue[0].trim().equals("")) {
                throw new EmptyNumberException();
            }
            if (validator == null || validator.isValid(Long.decode(paramValue[0]))) {
                return Long.decode(paramValue[0]);
            }
            log.error((Object)"Parameter is not in the numeric range especified");
            throw new IllegalArgumentException("Parameter is not in the numeric range especified");
        }
        if (desiredClassName.equals(Double.class.getName())) {
            if (paramValue[0] == null || paramValue[0].trim().equals("")) {
                throw new EmptyNumberException();
            }
            DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(new Locale(LocaleManager.currentLang()));
            String pattern = field.getFieldPattern();
            if (pattern != null && !"".equals(pattern)) {
                df.applyPattern(pattern);
            } else {
                df.applyPattern("###.##");
            }
            ParsePosition pp = new ParsePosition(0);
            Number num = df.parse(paramValue[0], pp);
            if (paramValue[0].length() != pp.getIndex() || num == null) {
                log.debug((Object)"Error on parsing value");
                throw new ParseException("Error parsing value", pp.getIndex());
            }
            double dvalue = num.doubleValue();
            if (validator == null || validator.isValid(new Double(dvalue))) {
                return new Double(dvalue);
            }
            log.error((Object)"Parameter is not in the numeric range especified");
            throw new IllegalArgumentException("Parameter is not in the numeric range especified");
        }
        throw new IllegalArgumentException("Invalid class for InputTextFieldHandler: " + desiredClassName);
    }

    public Map getParamValue(String inputName, Object objectValue, String pattern) {
        if (objectValue == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        if (objectValue.getClass().isArray()) {
            Object[] values = (Object[])objectValue;
            if (values.length > 0 && values[0] != null) {
                m.put(inputName + NUMERIC_FROM_SUFFIX, this.buildParamValue(values[0], pattern));
            }
            if (values.length > 1 && values[1] != null) {
                m.put(inputName + NUMERIC_TO_SUFFIX, this.buildParamValue(values[1], pattern));
            }
        } else {
            m.put(inputName, this.buildParamValue(objectValue, pattern));
        }
        return m;
    }

    protected String[] buildParamValue(Object value, String pattern) {
        String[] result = null;
        if (value != null && Arrays.asList(this.getCompatibleClassNames()).contains(value.getClass().getName())) {
            if (pattern != null && !"".equals(pattern)) {
                try {
                    DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(new Locale(LocaleManager.currentLang()));
                    df.applyPattern(pattern);
                    value = df.format((Double)value);
                }
                catch (Exception e) {
                    if (value instanceof Integer || value instanceof Long) {
                        log.warn((Object)("error building paramValue for value " + value + " with pattern " + pattern + ", let's try again without pattern..."));
                        return this.buildParamValue(value, null);
                    }
                    return result;
                }
            }
            result = new String[]{value.toString()};
        }
        return result;
    }

    public boolean acceptsPropertyName(String propName) {
        return true;
    }

    @Override
    public String getName() {
        return this.getComponentName();
    }

    public String[] getCompatibleClassNames() {
        return new String[]{"Currency", "InputTextInteger", "InputTextLong", "InputTextDouble"};
    }

    public boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                Object _value = values[i];
                if (_value == null) continue;
                return false;
            }
            return true;
        }
        return value != null && "".equals(value);
    }

    public String getPageToIncludeForRendering() {
        return this.pageToIncludeForRendering;
    }

    public void setPageToIncludeForRendering(String pageToIncludeForRendering) {
        this.pageToIncludeForRendering = pageToIncludeForRendering;
    }

    public String getPageToIncludeForDisplaying() {
        return this.pageToIncludeForDisplaying;
    }

    public void setPageToIncludeForDisplaying(String pageToIncludeForDisplaying) {
        this.pageToIncludeForDisplaying = pageToIncludeForDisplaying;
    }

    public String getPageToIncludeForSearching() {
        return this.pageToIncludeForSearching;
    }

    public void setPageToIncludeForSearching(String pageToIncludeForSearching) {
        this.pageToIncludeForSearching = pageToIncludeForSearching;
    }

    public class EmptyNumberException
    extends Exception {
    }
}

