/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.text.DecimalFormat;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;

public class RangeInputTextFieldHandlerFormatter
extends DefaultFieldHandlerFormatter {
    private static transient Log log = LogFactory.getLog((String)RangeInputTextFieldHandlerFormatter.class.getName());

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws FormatterException {
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(httpServletRequest);
        Field field = paramsReader.getCurrentField();
        Form form = paramsReader.getCurrentForm();
        Object value = paramsReader.getCurrentFieldValue();
        String fieldName = paramsReader.getCurrentFieldName();
        int position = paramsReader.getCurrentPosition();
        String namespace = paramsReader.getCurrentNamespace();
        boolean wrong = paramsReader.isWrongField();
        String inputValue = paramsReader.getInputValue();
        Boolean isDisabled = paramsReader.isFieldDisabled();
        Boolean isReadonly = paramsReader.isFieldReadonly();
        String formula = null;
        boolean forceShow = false;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Range Formula: [" + formula + "]"));
        }
        this.setDefaultAttributes(field, form, namespace);
        value = this.applyPattern(field, value);
        this.setAttribute("value", value);
        this.setAttribute("wrong", wrong);
        this.setAttribute("inputValue", inputValue);
        this.setAttribute("position", position);
        this.setAttribute("name", fieldName);
        this.setAttribute("lang", this.getLang());
        this.setAttribute("uid", this.getFormManager().getUniqueIdentifier(form, namespace, field, fieldName));
        if (isDisabled.booleanValue()) {
            this.setAttribute("disabled", isDisabled);
        }
        if (isReadonly.booleanValue()) {
            this.setAttribute("readonly", isReadonly);
        }
        this.renderFragment(forceShow ? "outputForceShowMode" : "output");
    }

    protected Object applyPattern(Field field, Object value) {
        if (value != null) {
            DecimalFormat nf;
            String pattern;
            if (value instanceof Double) {
                pattern = field.getPattern();
                if (pattern == null || "".equals(pattern)) {
                    pattern = field.getFieldType().getPattern();
                }
                if (pattern != null && !"".equals(value)) {
                    nf = (DecimalFormat)DecimalFormat.getInstance(this.getLocale());
                    nf.applyPattern(pattern);
                    value = nf.format((Double)value);
                }
            }
            if (value instanceof Object[]) {
                pattern = field.getPattern();
                if (pattern == null || "".equals(pattern)) {
                    pattern = field.getFieldType().getPattern();
                }
                if (pattern != null) {
                    nf = (DecimalFormat)DecimalFormat.getInstance(this.getLocale());
                    nf.applyPattern(pattern);
                    Object[] values = value;
                    for (int i = 0; i < values.length; ++i) {
                        Object object = values[i];
                        if (object == null || !(object instanceof Double)) continue;
                        Double aDouble = (Double)object;
                        values[i] = nf.format(aDouble);
                    }
                    value = values;
                }
            }
        }
        return value;
    }
}

