/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.processing.FormProcessor;
import org.jbpm.formModeler.core.config.FormManagerImpl;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeResponse;
import org.jbpm.formModeler.core.processing.formProcessing.NamespaceManager;
import org.jbpm.formModeler.service.bb.mvc.components.handling.HandlerFactoryElement;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandResponse;
import org.jbpm.formModeler.service.bb.mvc.controller.responses.DoNothingResponse;

public class FormChangeHandler
extends HandlerFactoryElement {
    private static transient Log log = LogFactory.getLog((String)FormChangeHandler.class.getName());
    private FormManagerImpl formsManager;
    private FormChangeProcessor changeProcessor;
    private NamespaceManager namespaceManager;
    private FormProcessor defaultFormProcessor;

    public void start() throws Exception {
        super.start();
        this.formsManager = FormManagerImpl.lookup();
    }

    public FormManagerImpl getFormsManager() {
        return this.formsManager;
    }

    public void setFormsManager(FormManagerImpl formsManager) {
        this.formsManager = formsManager;
    }

    public FormChangeProcessor getChangeProcessor() {
        return this.changeProcessor;
    }

    public void setChangeProcessor(FormChangeProcessor changeProcessor) {
        this.changeProcessor = changeProcessor;
    }

    public NamespaceManager getNamespaceManager() {
        return this.namespaceManager;
    }

    public void setNamespaceManager(NamespaceManager namespaceManager) {
        this.namespaceManager = namespaceManager;
    }

    public CommandResponse actionProcess(CommandRequest request) throws Exception {
        String modifiedFieldName = request.getParameter("modifiedFieldName");
        FormNamespaceData formNamespaceData = this.getNamespaceManager().getNamespace(modifiedFieldName);
        FormChangeResponse changeResponse = new FormChangeResponse();
        while (formNamespaceData != null) {
            this.defaultFormProcessor.setValues(formNamespaceData.getForm(), formNamespaceData.getNamespace(), request.getRequestObject().getParameterMap(), request.getFilesByParamName(), false);
            this.defaultFormProcessor.clearFieldErrors(formNamespaceData.getForm(), formNamespaceData.getNamespace());
            formNamespaceData = this.getNamespaceManager().getNamespace(formNamespaceData.getNamespace());
        }
        request.getResponseObject().setContentType("text/xml");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending form change response " + changeResponse.getXML()));
        }
        request.getResponseObject().getWriter().write(changeResponse.getXML());
        return new DoNothingResponse();
    }

    public FormProcessor getDefaultFormProcessor() {
        return this.defaultFormProcessor;
    }

    public void setDefaultFormProcessor(FormProcessor defaultFormProcessor) {
        this.defaultFormProcessor = defaultFormProcessor;
    }
}

