/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.config.FormManagerImpl;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.service.bb.commons.config.componentsFactory.BasicFactoryElement;

public class NamespaceManager
extends BasicFactoryElement {
    private static transient Log log = LogFactory.getLog((String)NamespaceManager.class.getName());

    public FormManagerImpl getFormsManager() {
        return FormManagerImpl.lookup();
    }

    public String getParentNamespace(String namespace) {
        int lastIndex;
        int previousLastIndex;
        if (namespace != null && (previousLastIndex = namespace.lastIndexOf("-", (lastIndex = namespace.lastIndexOf("-")) - 1)) != -1) {
            String parentNamespace = namespace.substring(0, previousLastIndex);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parent namespace for '" + namespace + "' is '" + parentNamespace + "'"));
            }
            return parentNamespace;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parent namespace for '" + namespace + "' is empty string"));
        }
        return "";
    }

    public FormNamespaceData getNamespace(String fieldName) {
        int lastIndex;
        int previousLastIndex;
        if (fieldName != null && (previousLastIndex = fieldName.lastIndexOf("-", (lastIndex = fieldName.lastIndexOf("-")) - 1)) != -1) {
            String formIdString = fieldName.substring(previousLastIndex + 1, lastIndex);
            String namespace = fieldName.substring(0, previousLastIndex);
            String fieldNameInParent = fieldName.substring(lastIndex + 1, fieldName.length());
            if (!"_".equals(formIdString)) {
                Long formId = Long.decode(formIdString);
                try {
                    Form form = this.getFormsManager().getFormById(formId);
                    return new FormNamespaceData(form, namespace, fieldNameInParent);
                }
                catch (Exception e) {
                    log.error((Object)"Error: ", (Throwable)e);
                }
            }
        }
        return null;
    }
}

