/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing.replacers;

import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.core.processing.formProcessing.replacers.FormulaReplacementContext;
import org.jbpm.formModeler.core.processing.formProcessing.replacers.FormulaReplacer;

public class ThisReplacer
implements FormulaReplacer {
    public static final String THIS_TOKEN = "{$this}";

    @Override
    public String replace(FormulaReplacementContext ctx) {
        if (ctx.isBeforeFieldEvaluation()) {
            if (this.isFormulaSurroundedByQuotes(ctx.getFormula())) {
                return StringUtils.replace((String)ctx.getFormula(), (String)THIS_TOKEN, (String)ctx.getParamValue());
            }
            return StringUtils.replace((String)ctx.getFormula(), (String)THIS_TOKEN, (String)("\"" + ctx.getParamValue() + "\""));
        }
        return StringUtils.replace((String)ctx.getFormula(), (String)THIS_TOKEN, (String)("{" + ctx.getField().getFieldName() + "}"));
    }

    protected boolean isFormulaSurroundedByQuotes(String formula) {
        if (StringUtils.isEmpty((String)formula) || !formula.contains(THIS_TOKEN)) {
            return false;
        }
        return this.hasOpenQuote(formula) && this.hasCloseQuote(formula);
    }

    protected boolean hasOpenQuote(String formula) {
        int count = this.countQuotes(formula.substring(0, formula.indexOf(THIS_TOKEN)));
        return count % 2 != 0;
    }

    protected boolean hasCloseQuote(String formula) {
        int count = this.countQuotes(formula.substring(formula.indexOf(THIS_TOKEN) + 1));
        return count % 2 != 0;
    }

    private int countQuotes(String formula) {
        int count = 0;
        for (int i = 0; i < formula.length(); ++i) {
            if (formula.charAt(i) != '\"') continue;
            ++count;
        }
        return count;
    }
}

