/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formRendering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.api.processing.FormProcessor;
import org.jbpm.formModeler.api.processing.FormStatusData;
import org.jbpm.formModeler.service.bb.commons.config.LocaleManager;
import org.jbpm.formModeler.service.bb.commons.config.componentsFactory.BasicFactoryElement;

public class FormErrorMessageBuilder
extends BasicFactoryElement {
    private static transient Log log = LogFactory.getLog((String)FormErrorMessageBuilder.class.getName());
    private ResourceBundle bundle = ResourceBundle.getBundle("org.jbpm.formModeler.core.processing.formRendering.messages", LocaleManager.currentLocale());
    private String requiredMessage = this.bundle.getString("errorMessages.required");
    private FormProcessor defaultFormProcessor;
    private LocaleManager localeManager;

    public List getWrongFormErrors(String namespace, Form formulary) {
        ArrayList<String> errors = new ArrayList<String>();
        if (namespace != null && formulary != null) {
            try {
                FormStatusData statusData = this.defaultFormProcessor.read(formulary.getId(), namespace);
                for (int i = 0; i < statusData.getWrongFields().size(); ++i) {
                    Field field = formulary.getField((String)statusData.getWrongFields().get(i));
                    Boolean fieldIsRequired = field.getFieldRequired();
                    boolean fieldRequired = fieldIsRequired != null && fieldIsRequired != false && !"display".equals(fieldIsRequired);
                    String currentNamespace = namespace + "-" + formulary.getId().intValue() + "-" + field.getFieldName();
                    String currentValue = statusData.getCurrentInputValue(currentNamespace);
                    if (!statusData.hasErrorMessage(field.getFieldName())) {
                        if (!fieldRequired || !StringUtils.isEmpty((String)currentValue) || errors.contains(this.requiredMessage)) continue;
                        errors.add(0, this.requiredMessage);
                        continue;
                    }
                    errors.addAll(this.getErrorMessages(statusData.getErrorMessages(field.getFieldName()), field));
                }
            }
            catch (Exception e) {
                log.error((Object)("Error getting error messages for form " + formulary.getId() + ": "), (Throwable)e);
            }
        }
        return errors;
    }

    protected List getErrorMessages(List msgs, Field field) {
        if (CollectionUtils.isEmpty((Collection)msgs)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object msg : msgs) {
            result.add(this.getErrorMessage((String)msg, field));
        }
        return result;
    }

    protected String getErrorMessage(String msg, Field field) {
        if (StringUtils.isEmpty((String)msg)) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        String label = field.getFieldName().indexOf(":decorator") > -1 ? (String)field.getLabel().get((Object)LocaleManager.currentLang()) : field.getFieldName();
        result.append(this.bundle.getString("error.start")).append(label).append(this.bundle.getString("error.end")).append(msg);
        return result.toString();
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    public FormProcessor getDefaultFormProcessor() {
        return this.defaultFormProcessor;
    }

    public void setDefaultFormProcessor(FormProcessor defaultFormProcessor) {
        this.defaultFormProcessor = defaultFormProcessor;
    }
}

