/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formRendering;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.api.processing.FormProcessor;
import org.jbpm.formModeler.api.processing.FormStatusData;
import org.jbpm.formModeler.core.config.FormManagerImpl;
import org.jbpm.formModeler.service.bb.commons.config.LocaleManager;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.Formatter;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;

public class FormErrorsFormatter
extends Formatter {
    private static transient Log log = LogFactory.getLog((String)FormErrorsFormatter.class.getName());
    private LocaleManager localeManager;
    private FormManagerImpl formManagerImpl;
    private FormProcessor defaultFormProcessor;
    private int maxVisibleErrors = 5;

    public void start() throws Exception {
        super.start();
        this.formManagerImpl = FormManagerImpl.lookup();
    }

    public LocaleManager getLocaleManager() {
        return this.localeManager;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    public FormManagerImpl getFormManager() {
        return this.formManagerImpl;
    }

    public void setFormManager(FormManagerImpl formManagerImpl) {
        this.formManagerImpl = formManagerImpl;
    }

    public int getMaxVisibleErrors() {
        return this.maxVisibleErrors;
    }

    public void setMaxVisibleErrors(int maxVisibleErrors) {
        this.maxVisibleErrors = maxVisibleErrors;
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws FormatterException {
        Long formId;
        String namespace = httpServletRequest.getAttribute("namespace") != null ? (String)httpServletRequest.getAttribute("namespace") : "";
        List errorsToShow = this.getFormFieldErrors(namespace, formId = httpServletRequest.getAttribute("formId") != null ? (Long)httpServletRequest.getAttribute("formId") : null);
        if (errorsToShow.size() > 0) {
            this.renderFragment("outputStart");
            this.renderFragment("outputErrorsStart");
            for (int i = 0; i < errorsToShow.size(); ++i) {
                this.setAttribute("errorMsg", errorsToShow.get(i));
                this.setAttribute("namespace", namespace);
                this.setAttribute("index", i);
                this.setAttribute("display", i < this.getMaxVisibleErrors() ? "" : "none");
                this.renderFragment("outputError");
            }
            this.renderFragment("outputErrorsEnd");
            if (errorsToShow.size() > this.getMaxVisibleErrors()) {
                this.setAttribute("namespace", namespace);
                this.setAttribute("min", this.getMaxVisibleErrors());
                this.setAttribute("max", errorsToShow.size());
                this.renderFragment("outputDisplayLinks");
            }
            this.renderFragment("outputEnd");
        }
    }

    public List getFormFieldErrors(String namespace, Long formId) {
        ArrayList<String> errorsToShow = new ArrayList<String>();
        if (formId != null && namespace != null) {
            try {
                Form form = this.formManagerImpl.getFormById(formId);
                FormStatusData statusData = this.defaultFormProcessor.read(formId, namespace);
                for (int i = 0; i < statusData.getWrongFields().size(); ++i) {
                    Field field = form.getField((String)statusData.getWrongFields().get(i));
                    Boolean fieldIsRequired = field.getFieldRequired();
                    boolean fieldRequired = fieldIsRequired != null && fieldIsRequired != false && !"display".equals(fieldIsRequired);
                    String currentValue = statusData.getCurrentInputValue(namespace + "-" + formId.intValue() + "-" + field.getFieldName());
                    if (!fieldRequired || currentValue != null && !currentValue.trim().equals("")) continue;
                    errorsToShow.clear();
                    ResourceBundle bundle = ResourceBundle.getBundle("org.jbpm.formModeler.core.processing.formRendering.messages", LocaleManager.currentLocale());
                    errorsToShow.add(bundle.getString("errorMessages.required"));
                    break;
                }
            }
            catch (Exception e) {
                log.error((Object)("Error getting error messages for object " + formId + ": "), (Throwable)e);
            }
        }
        return errorsToShow;
    }

    public FormProcessor getDefaultFormProcessor() {
        return this.defaultFormProcessor;
    }

    public void setDefaultFormProcessor(FormProcessor defaultFormProcessor) {
        this.defaultFormProcessor = defaultFormProcessor;
    }
}

