/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formStatus;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.api.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.processing.formProcessing.NamespaceManager;
import org.jbpm.formModeler.core.processing.formStatus.FormStatus;
import org.jbpm.formModeler.service.bb.commons.config.componentsFactory.Factory;

public class FormStatusManager {
    private static transient Log log = LogFactory.getLog((String)FormStatusManager.class.getName());
    private Map formStatuses = new Hashtable();
    public NamespaceManager namespaceManager;

    public FormStatus getFormStatus(Long formId, String namespace) {
        namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        return (FormStatus)this.formStatuses.get(namespace + "-" + formId);
    }

    public FormStatus createFormStatus(Long formId, String namespace) {
        namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        FormStatus fs = new FormStatus(formId, namespace);
        this.formStatuses.put(namespace + "-" + formId, fs);
        try {
            Form form = this.namespaceManager.getFormsManager().getFormById(formId);
            for (Field pff : form.getFormFields()) {
                FieldHandler handler = (FieldHandler)Factory.lookup((String)pff.getFieldType().getManagerClass());
                handler.initialize(pff, namespace);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error: ", (Throwable)e);
        }
        return fs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyFormStatus(Long formId, String namespace) {
        namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        String requestedPreffix = namespace + "-" + formId;
        Map map = this.formStatuses;
        synchronized (map) {
            Iterator it = this.formStatuses.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!key.startsWith(requestedPreffix)) continue;
                it.remove();
            }
        }
    }

    public void cascadeClearWrongFields(Long formId, String namespace) {
        namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        String requestedPreffix = namespace + "-" + formId;
        for (String key : this.formStatuses.keySet()) {
            if (!key.startsWith(requestedPreffix)) continue;
            FormStatus formStatus = (FormStatus)this.formStatuses.get(key);
            formStatus.clearFormErrors();
        }
    }

    public FormStatus getParent(FormStatus fs) {
        if (fs == null) {
            return null;
        }
        String namespace = fs.getNamespace();
        if (StringUtils.isEmpty((String)namespace)) {
            return null;
        }
        FormNamespaceData fsd = this.namespaceManager.getNamespace(namespace);
        if (fsd == null) {
            return null;
        }
        return this.getFormStatus(fsd.getForm().getId(), fsd.getNamespace());
    }
}

