/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.api.model.i18n.I18nSet;
import org.jbpm.formModeler.api.processing.FieldHandler;
import org.jbpm.formModeler.api.processing.FormProcessor;
import org.jbpm.formModeler.api.processing.FormStatusData;
import org.jbpm.formModeler.api.util.helpers.CDIHelper;
import org.jbpm.formModeler.core.config.FormManagerImpl;
import org.jbpm.formModeler.core.processing.ProcessingMessagedException;
import org.jbpm.formModeler.core.processing.fieldHandlers.NumericFieldHandler;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeResponse;
import org.jbpm.formModeler.core.processing.formStatus.FormStatus;
import org.jbpm.formModeler.core.processing.formStatus.FormStatusManager;
import org.jbpm.formModeler.core.processing.impl.FormStatusDataImpl;
import org.jbpm.formModeler.service.bb.commons.config.componentsFactory.BasicFactoryElement;
import org.jbpm.formModeler.service.bb.commons.config.componentsFactory.Factory;

public class FormProcessorImpl
extends BasicFactoryElement
implements FormProcessor {
    private static transient Log log = LogFactory.getLog((String)FormProcessorImpl.class.getName());
    private FormChangeProcessor formChangeProcessor;
    private FormStatusManager formStatusManager;

    public FormStatusManager getFormStatusManager() {
        return this.formStatusManager;
    }

    public void setFormStatusManager(FormStatusManager formStatusManager) {
        this.formStatusManager = formStatusManager;
    }

    public FormChangeProcessor getFormChangeProcessor() {
        return this.formChangeProcessor;
    }

    public void setFormChangeProcessor(FormChangeProcessor formChangeProcessor) {
        this.formChangeProcessor = formChangeProcessor;
    }

    public String getFactoryName() {
        return this.getComponentName();
    }

    protected FormStatus getFormStatus(Long formId, String namespace) {
        return this.getFormStatus(formId, namespace, new HashMap());
    }

    protected FormStatus getFormStatus(Long formId, String namespace, Map currentValues) {
        FormStatus formStatus = this.getFormStatusManager().getFormStatus(formId, namespace);
        return formStatus != null ? formStatus : this.createFormStatus(formId, namespace, currentValues);
    }

    protected boolean existsFormStatus(Long formId, String namespace) {
        FormStatus formStatus = this.getFormStatusManager().getFormStatus(formId, namespace);
        return formStatus != null;
    }

    protected FormStatus createFormStatus(Long formId, String namespace) {
        return this.createFormStatus(formId, namespace, new HashMap());
    }

    protected FormStatus createFormStatus(Long formId, String namespace, Map currentValues) {
        FormStatus fStatus = this.formStatusManager.createFormStatus(formId, namespace);
        this.setDefaultValues(formId, namespace, currentValues);
        return fStatus;
    }

    protected void setDefaultValues(Long formId, String namespace, Map currentValues) {
        Form pf = null;
        try {
            pf = this.getFormsManager().getFormById(formId);
        }
        catch (Exception e) {
            log.error((Object)("Error recovering Form with id " + formId + ", no field default values will be set"), (Throwable)e);
        }
        if (pf != null) {
            Set formFields = pf.getFormFields();
            HashMap params = new HashMap(5);
            for (Field pField : formFields) {
                Object value = currentValues.get(pField.getFieldName());
                String inputName = this.getPrefix(pf, namespace) + pField.getFieldName();
                try {
                    Map paramValue;
                    FieldHandler handler = (FieldHandler)Factory.lookup((String)pField.getFieldType().getManagerClass());
                    if (value instanceof Map && !((Map)value).containsKey("-jbpm-formMode") && !(value instanceof I18nSet)) {
                        ((Map)value).put("-jbpm-formMode", currentValues.get("-jbpm-formMode"));
                    }
                    if ((paramValue = handler.getParamValue(inputName, value, pField.getPattern())) == null || paramValue.isEmpty()) continue;
                    params.putAll(paramValue);
                }
                catch (Exception e) {
                    log.error((Object)("Error obtaining default values for " + inputName), (Throwable)e);
                }
            }
            this.setValues(pf, namespace, params, null, true);
        }
    }

    protected void destroyFormStatus(Long formId, String namespace) {
        this.formStatusManager.destroyFormStatus(formId, namespace);
    }

    public void setValues(Form form, String namespace, Map parameterMap, Map filesMap) {
        this.setValues(form, namespace, parameterMap, filesMap, false);
    }

    public void setValues(Form form, String namespace, Map parameterMap, Map filesMap, boolean incremental) {
        if (form != null) {
            namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
            FormStatus formStatus = this.getFormStatus(form.getId(), namespace);
            if (incremental) {
                HashMap mergedParameterMap = new HashMap();
                if (formStatus.getLastParameterMap() != null) {
                    mergedParameterMap.putAll(formStatus.getLastParameterMap());
                }
                if (parameterMap != null) {
                    mergedParameterMap.putAll(parameterMap);
                }
                formStatus.setLastParameterMap(mergedParameterMap);
            } else {
                formStatus.setLastParameterMap(parameterMap);
            }
            String inputsPrefix = this.getPrefix(form, namespace);
            for (Field field : form.getFormFields()) {
                this.setFieldValue(field, formStatus, inputsPrefix, parameterMap, filesMap, incremental);
            }
        }
    }

    public void modify(Form form, String namespace, String fieldName, Object value) {
        FormStatus formStatus = this.getFormStatus(form.getId(), namespace);
        formStatus.getInputValues().put(fieldName, value);
        this.propagateChangesToParentFormStatuses(formStatus, fieldName, value);
    }

    public void setAttribute(Form form, String namespace, String attributeName, Object attributeValue) {
        if (form != null) {
            FormStatus formStatus = this.getFormStatus(form.getId(), namespace);
            formStatus.getAttributes().put(attributeName, attributeValue);
        }
    }

    public Object getAttribute(Form form, String namespace, String attributeName) {
        if (form != null) {
            FormStatus formStatus = this.getFormStatus(form.getId(), namespace);
            return formStatus.getAttributes().get(attributeName);
        }
        return null;
    }

    protected void setFieldValue(Field field, FormStatus formStatus, String inputsPrefix, Map parameterMap, Map filesMap, boolean incremental) {
        block12: {
            String fieldName = field.getFieldName();
            String inputName = inputsPrefix + fieldName;
            FieldHandler handler = (FieldHandler)Factory.lookup((String)field.getFieldType().getManagerClass());
            try {
                Object previousValue = formStatus.getInputValues().get(fieldName);
                boolean isRequired = field.getFieldRequired();
                if (!(handler.isEvaluable(inputName, parameterMap, filesMap) || handler.isEmpty(previousValue) && isRequired)) {
                    return;
                }
                Object value = null;
                boolean emptyNumber = false;
                try {
                    value = handler.getValue(field, inputName, parameterMap, filesMap, field.getFieldType().getFieldClass(), previousValue);
                }
                catch (NumericFieldHandler.EmptyNumberException ene) {
                    emptyNumber = true;
                }
                if (incremental && value == null && !emptyNumber) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Refusing to overwrite input value for parameter " + fieldName));
                    }
                    break block12;
                }
                formStatus.getInputValues().put(fieldName, value);
                try {
                    this.propagateChangesToParentFormStatuses(formStatus, fieldName, value);
                }
                catch (Exception e) {
                    log.error((Object)"Error modifying formStatus: ", (Throwable)e);
                }
                boolean isEmpty = handler.isEmpty(value);
                if (isRequired && isEmpty && !incremental) {
                    log.debug((Object)("Missing required field " + fieldName));
                    formStatus.getWrongFields().add(fieldName);
                } else {
                    formStatus.removeWrongField(fieldName);
                }
            }
            catch (ProcessingMessagedException pme) {
                log.debug((Object)"Processing field: ", (Throwable)pme);
                formStatus.addErrorMessages(fieldName, pme.getMessages());
            }
            catch (Exception e) {
                log.debug((Object)"Error setting field value:", (Throwable)e);
                if (incremental) break block12;
                formStatus.getInputValues().put(fieldName, null);
                formStatus.getWrongFields().add(fieldName);
            }
        }
    }

    protected void propagateChangesToParentFormStatuses(FormStatus formStatus, String fieldName, Object value) {
        FormStatus parent = this.getFormStatusManager().getParent(formStatus);
        if (parent != null) {
            String fieldNameInParent = this.getFormStatusManager().namespaceManager.getNamespace(formStatus.getNamespace()).getFieldNameInParent();
            Object valueInParent = parent.getInputValues().get(fieldNameInParent);
            if (valueInParent != null) {
                Integer pos;
                Map editFieldPositions;
                Map parentMapObjectRepresentation = null;
                if (valueInParent instanceof Map) {
                    parentMapObjectRepresentation = (Map)valueInParent;
                } else if (valueInParent instanceof Map[] && (editFieldPositions = (Map)parent.getAttributes().get("-pot-editFieldPositions")) != null && (pos = (Integer)editFieldPositions.get(fieldNameInParent)) != null) {
                    parentMapObjectRepresentation = ((Map[])valueInParent)[pos];
                }
                if (parentMapObjectRepresentation != null) {
                    parentMapObjectRepresentation.put(fieldName, value);
                    this.propagateChangesToParentFormStatuses(parent, fieldNameInParent, valueInParent);
                }
            }
        }
    }

    public FormStatusData read(Long formId, String namespace, Map currentValues) {
        boolean exists = this.existsFormStatus(formId, namespace);
        if (currentValues == null) {
            currentValues = new HashMap();
        }
        FormStatus formStatus = this.getFormStatus(formId, namespace, currentValues);
        FormStatusDataImpl data = null;
        try {
            data = new FormStatusDataImpl(formStatus, !exists);
        }
        catch (Exception e) {
            log.error((Object)"Error: ", (Throwable)e);
        }
        return data;
    }

    public FormStatusData read(Long formId, String namespace) {
        return this.read(formId, namespace, new HashMap());
    }

    public void flushPendingCalculations(Form form, String namespace) {
        if (this.getFormChangeProcessor() != null) {
            this.getFormChangeProcessor().process(form, namespace, new FormChangeResponse());
        }
    }

    public Map getMapRepresentationToPersist(Form form, String namespace) throws Exception {
        namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        this.flushPendingCalculations(form, namespace);
        HashMap m = new HashMap();
        FormStatus formStatus = this.getFormStatus(form.getId(), namespace);
        if (!formStatus.getWrongFields().isEmpty()) {
            throw new IllegalArgumentException("Validation error.");
        }
        this.fillObjectValues(m, formStatus.getInputValues(), form);
        TreeSet s = (TreeSet)m.get("-jbpm-modifiedFieldNames");
        if (s == null) {
            s = new TreeSet();
            m.put("-jbpm-modifiedFieldNames", s);
        }
        s.addAll(form.getFieldNames());
        return m;
    }

    protected Map getFilteredMapRepresentationToPersist(Form form, String namespace) throws Exception {
        Map inputValues = this.getMapRepresentationToPersist(form, namespace);
        Map mapToPersist = this.filterMapRepresentationToPersist(inputValues);
        return mapToPersist;
    }

    public Map filterMapRepresentationToPersist(Map inputValues) throws Exception {
        HashMap filteredMap = new HashMap();
        Set keys = inputValues.keySet();
        for (String key : keys) {
            filteredMap.put(key, inputValues.get(key));
        }
        return filteredMap;
    }

    protected void fillObjectValues(Map obj, Map values, Form form) throws Exception {
        HashMap valuesToSet = new HashMap();
        for (String propertyName : values.keySet()) {
            Object propertyValue = values.get(propertyName);
            valuesToSet.put(propertyName, propertyValue);
        }
        obj.putAll(valuesToSet);
    }

    public void load(Long formId, String namespace, Long objIdentifier, String itemClassName) throws Exception {
        this.load(formId, namespace, objIdentifier, itemClassName, null);
    }

    public void load(Long formId, String namespace, Long objIdentifier, String itemClassName, String formMode) throws Exception {
        namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        FormStatus formStatus = this.createFormStatus(formId, namespace);
        formStatus.setLoadedItemId(objIdentifier);
        formStatus.setLoadedItemClass(itemClassName);
        this.load(formId, namespace, this.getLoadedObject(formId, namespace), formMode);
    }

    public void load(Long formId, String namespace, Object loadObject) throws Exception {
        this.load(formId, namespace, loadObject, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Long formId, String namespace, Object loadObject, String formMode) throws Exception {
        namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        if (loadObject == null) {
            FormStatus formStatus = this.getFormStatus(formId, namespace);
            formStatus.setLoadedItemId(null);
            formStatus.setLoadedItemClass(null);
            this.setValues(this.getFormsManager().getFormById(formId), namespace, Collections.EMPTY_MAP, Collections.EMPTY_MAP, true);
        } else {
            Object object = loadObject;
            synchronized (object) {
                FormStatus formStatus = this.getFormStatus(formId, namespace, (Map)loadObject);
                if (loadObject instanceof Map) {
                    Map obj = (Map)loadObject;
                    for (String key : obj.keySet()) {
                        Object value = obj.get(key);
                        if (value == null) continue;
                        formStatus.getInputValues().put(key, value);
                    }
                }
            }
        }
    }

    protected FormManagerImpl getFormsManager() {
        return (FormManagerImpl)CDIHelper.getBeanByType(FormManagerImpl.class);
    }

    public Object getLoadedObject(Long formId, String namespace) throws Exception {
        FormStatus formStatus = this.getFormStatus(formId, namespace);
        Object loadedObject = null;
        if (formStatus != null) {
            Long objIdentifier = formStatus.getLoadedItemId();
            String itemClassName = formStatus.getLoadedItemClass();
        }
        return loadedObject;
    }

    public void clear(Long formId, String namespace) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing form status for formulary " + formId + " with namespace '" + namespace + "'"));
        }
        this.destroyFormStatus(formId, namespace);
    }

    public void clearField(Long formId, String namespace, String fieldName) {
        FormStatus formStatus = this.getFormStatus(formId, namespace);
        formStatus.getInputValues().remove(fieldName);
    }

    public void clearFieldErrors(Form form, String namespace) {
        this.formStatusManager.cascadeClearWrongFields(form.getId(), namespace);
    }

    public void forceWrongField(Form form, String namespace, String fieldName) {
        this.formStatusManager.getFormStatus(form.getId(), namespace).getWrongFields().add(fieldName);
    }

    public void clear(Long formId) {
        this.clear(formId, "");
    }

    public Object getLoadedObject(Long formId) throws Exception {
        return this.getLoadedObject(formId, "");
    }

    public void load(Long formId, Object loadObject) throws Exception {
        this.load(formId, "", loadObject);
    }

    public void load(Long formId, Long objIdentifier, String itemClassName) throws Exception {
        this.load(formId, "", objIdentifier, itemClassName);
    }

    public FormStatusData read(Long formId) {
        return this.read(formId, "");
    }

    public void setValues(Form form, Map parameterMap, Map filesMap) {
        this.setValues(form, "", parameterMap, filesMap);
    }

    public void setValues(Form form, Map parameterMap, Map filesMap, boolean incremental) {
        this.setValues(form, "", parameterMap, filesMap, incremental);
    }

    protected String getPrefix(Form form, String namespace) {
        return namespace + "-" + form.getId() + "-";
    }
}

