/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.core.processing.DefaultFieldHandler;

public class DateFieldHandler
extends DefaultFieldHandler {
    private static transient Log log = LogFactory.getLog((String)DateFieldHandler.class.getName());
    public static final String DATE_FROM_SUFFIX = "_from";
    public static final String HAS_CHANGED_PARAM = "_hasChanged";
    public static final String DATE_PATTERN_SUFFIX = "_pattern";
    public static final Date DEFAULT_MIN_DATE = new Date(0L);
    public static final String DATE_TO_SUFFIX = "_to";
    protected String defaultPattern = "MM-dd-yy";
    protected String defaultPatterTimeSuffix = "HH:mm:ss";
    protected String defaultJQueryPattern = "mm-dd-y";

    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        Object[] dateFromValue = (String[])parametersMap.get(inputName + DATE_FROM_SUFFIX);
        Object[] dateToValue = (String[])parametersMap.get(inputName + DATE_TO_SUFFIX);
        Object[] hasChangedParam = (String[])parametersMap.get(inputName + HAS_CHANGED_PARAM);
        try {
            boolean hasChanged = !ArrayUtils.isEmpty((Object[])hasChangedParam) && Boolean.TRUE.equals(Boolean.parseBoolean((String)hasChangedParam[0]));
            SimpleDateFormat sdf = this.getSimpleDateFormat(field, hasChanged, field.getFieldPattern());
            if (!ArrayUtils.isEmpty((Object[])dateFromValue) || !ArrayUtils.isEmpty((Object[])dateToValue)) {
                Object from = this.getTheDate((String[])dateFromValue, sdf);
                Object to = this.getTheDate((String[])dateToValue, sdf);
                return new Object[]{from, to};
            }
            Object[] dateValue = (String[])parametersMap.get(inputName);
            if (!ArrayUtils.isEmpty((Object[])dateValue)) {
                return this.getTheDate((String[])dateValue, sdf);
            }
        }
        catch (ParseException e) {
            log.debug((Object)"Error:", (Throwable)e);
        }
        return previousValue;
    }

    public String[] getCompatibleClassNames() {
        return new String[]{Date.class.getName()};
    }

    public boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                Object date = values[i];
                if (date == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getDefaultPattern() {
        return this.defaultPattern;
    }

    public void setDefaultPattern(String defaultPattern) {
        this.defaultPattern = defaultPattern;
    }

    public String getDefaultJQueryPattern() {
        return this.defaultJQueryPattern;
    }

    public void setDefaultJQueryPattern(String defaultJQueryPattern) {
        this.defaultJQueryPattern = defaultJQueryPattern;
    }

    protected String getPattern(Field field, boolean useDefault, String pattern) {
        if (!useDefault && field != null && !StringUtils.isEmpty((String)field.getPattern())) {
            pattern = field.getPattern();
        }
        return StringUtils.defaultString((String)pattern);
    }

    protected SimpleDateFormat getSimpleDateFormat(Field field, boolean useDefault, String pattern) {
        return new SimpleDateFormat(this.getPattern(field, useDefault, pattern));
    }

    public Object getTheDate(String[] values, SimpleDateFormat sdf) throws Exception {
        String date = !ArrayUtils.isEmpty((Object[])values) ? values[0] : null;
        return !StringUtils.isEmpty((String)date) ? sdf.parse(date) : null;
    }

    public Map getParamValue(String inputName, Object objectValue, String pattern) {
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        if (objectValue != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(StringUtils.defaultString((String)pattern, (String)this.defaultPattern));
            if (objectValue instanceof Date) {
                m.put(inputName, new String[]{sdf.format(objectValue)});
            } else if (objectValue instanceof Object[]) {
                Object[] dateArray = (Object[])objectValue;
                if (dateArray.length > 0 && dateArray[0] != null) {
                    m.put(inputName + DATE_FROM_SUFFIX, new String[]{sdf.format(dateArray[0])});
                }
                if (dateArray.length > 1 && dateArray[1] != null) {
                    m.put(inputName + DATE_TO_SUFFIX, new String[]{sdf.format(dateArray[1])});
                }
            }
        }
        return m;
    }

    public boolean acceptsPropertyName(String propName) {
        return true;
    }

    public String getDefaultPatterTimeSuffix() {
        return this.defaultPatterTimeSuffix;
    }

    public void setDefaultPatterTimeSuffix(String defaultPatterTimeSuffix) {
        this.defaultPatterTimeSuffix = defaultPatterTimeSuffix;
    }
}

