/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.PersistentFieldHandler;
import org.jbpm.formModeler.core.processing.formRendering.FormErrorMessageBuilder;
import org.jbpm.formModeler.core.rendering.SubformFinderService;

@Named(value="org.jbpm.formModeler.core.processing.fieldHandlers.SubformFieldHandler")
public class SubformFieldHandler
extends PersistentFieldHandler {
    private static transient Log log = LogFactory.getLog((String)SubformFieldHandler.class.getName());
    @Inject
    private SubformFinderService subformFinderService;
    @Inject
    private FormErrorMessageBuilder formErrorMessageBuilder;
    private String pageToIncludeForRendering = "/formModeler/fieldHandlers/Subform/input.jsp";
    private String pageToIncludeForDisplaying = "/formModeler/fieldHandlers/Subform/show.jsp";
    private String pageToIncludeForSearching = "/formModeler/fieldHandlers/Subform/search.jsp";
    private static int maxDepth = 2;

    public String[] getCompatibleClassNames() {
        return new String[]{Object.class.getName()};
    }

    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        Form form = this.getEnterDataForm(inputName, field);
        if (!SubformFieldHandler.checkSubformDepthAllowed(form.getId(), inputName)) {
            return null;
        }
        this.getFormProcessor().setValues(form, inputName, parametersMap, filesMap);
        FormStatusData status = this.getFormProcessor().read(form, inputName);
        if (status.isValid()) {
            if (status.isEmpty()) {
                return null;
            }
            Map m = this.getFormProcessor().getMapRepresentationToPersist(form, inputName);
            return m;
        }
        throw new IllegalArgumentException("Subform status is invalid.");
    }

    @Override
    public Object persist(Field field, String inputName, String desiredClass) throws Exception {
        Form form = this.getEnterDataForm(inputName, field);
        Map representation = this.getFormProcessor().getMapRepresentationToPersist(form, inputName);
        return this.getFormProcessor().persistFormHolder(form, inputName, representation, form.getDataHolderByInfo(field.getSubformClass()));
    }

    public Map getParamValue(String inputName, Object value, String pattern) {
        if (value == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap m = new HashMap();
        FormNamespaceData data = this.getNamespaceManager().getNamespace(inputName);
        Field parentField = data.getForm().getField(data.getFieldNameInParent());
        Form childForm = this.getEnterDataForm(inputName, parentField);
        DataHolder holder = childForm.getDataHolderByInfo(parentField.getSubformClass());
        for (Field childField : childForm.getFormFields()) {
            String bindingExpression = StringUtils.defaultIfEmpty((String)childField.getInputBinding(), (String)childField.getOutputBinding());
            if (!holder.isAssignableForField(childField)) continue;
            try {
                Object val = holder.readFromBindingExperssion(value, bindingExpression);
                FieldHandler fieldManager = this.getFieldHandlersManager().getHandler(childField.getFieldType());
                Map childrenMap = fieldManager.getParamValue(inputName + "-" + childForm.getId() + "-" + childField.getFieldName(), val, childField.getFieldPattern());
                if (childrenMap == null) continue;
                m.putAll(childrenMap);
            }
            catch (Exception e) {
                log.warn((Object)("Error reading value from field '" + childField.getFieldName() + "': "), (Throwable)e);
            }
        }
        return m;
    }

    public List getWrongChildFieldErrors(String namespace, Field field) {
        return this.formErrorMessageBuilder.getWrongFormErrors(namespace, this.getEnterDataForm(namespace, field));
    }

    @Override
    public String getPageToIncludeForDisplaying() {
        return this.pageToIncludeForDisplaying;
    }

    public boolean isEmpty(Object value) {
        return value == null || "".equals(value);
    }

    public void setPageToIncludeForDisplaying(String pageToIncludeForDisplaying) {
        this.pageToIncludeForDisplaying = pageToIncludeForDisplaying;
    }

    public boolean acceptsPropertyName(String propName) {
        return true;
    }

    @Override
    public String getPageToIncludeForRendering() {
        return this.pageToIncludeForRendering;
    }

    public void setPageToIncludeForRendering(String pageToIncludeForRendering) {
        this.pageToIncludeForRendering = pageToIncludeForRendering;
    }

    @Override
    public String getPageToIncludeForSearching() {
        return this.pageToIncludeForSearching;
    }

    public void setPageToIncludeForSearching(String pageToIncludeForSearching) {
        this.pageToIncludeForSearching = pageToIncludeForSearching;
    }

    protected Form getEnterDataForm(String namespace, Field field) {
        String formName = field.getDefaultSubform();
        return this.getForm(formName, namespace);
    }

    private Form getForm(String formPath, String namespace) {
        return this.subformFinderService.getFormFromPath(formPath, namespace);
    }

    public static boolean checkSubformDepthAllowed(Long id, String namesapce) {
        StringTokenizer token = new StringTokenizer(namesapce, "-", false);
        String _id = id.toString();
        int count = 0;
        while (token.hasMoreElements()) {
            String idToCompare = (String)token.nextElement();
            if (!idToCompare.equals(_id) || ++count < maxDepth) continue;
            return false;
        }
        return true;
    }
}

