/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formRendering;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormProcessingServices;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.fieldHandlers.SubformFieldHandler;
import org.jbpm.formModeler.service.LocaleManager;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

public class FormErrorMessageBuilder {
    @Inject
    private Log log;
    private ResourceBundle bundle;
    private String requiredMessage;

    @PostConstruct
    protected void init() {
        this.bundle = ResourceBundle.getBundle("org.jbpm.formModeler.core.processing.formRendering.messages", LocaleManager.currentLocale());
        this.requiredMessage = this.bundle.getString("errorMessages.required");
    }

    public List getWrongFormErrors(String namespace, Form form) {
        ArrayList<String> errors = new ArrayList<String>();
        if (namespace != null && form != null) {
            try {
                FormStatusData statusData = FormProcessingServices.lookup().getFormProcessor().read(form, namespace);
                for (int i = 0; i < statusData.getWrongFields().size(); ++i) {
                    Field field = form.getField((String)statusData.getWrongFields().get(i));
                    FieldHandler fieldHanlder = (FieldHandler)CDIBeanLocator.getBeanByNameOrType((String)field.getFieldType().getManagerClass());
                    boolean isSubform = fieldHanlder instanceof SubformFieldHandler;
                    Boolean fieldIsRequired = field.getFieldRequired();
                    boolean fieldRequired = fieldIsRequired != null && fieldIsRequired != false && !"display".equals(fieldIsRequired);
                    String currentNamespace = namespace + "-" + form.getId().intValue() + "-" + field.getFieldName();
                    String currentValue = statusData.getCurrentInputValue(currentNamespace);
                    if (isSubform) {
                        errors.addAll(((SubformFieldHandler)fieldHanlder).getWrongChildFieldErrors(currentNamespace, field));
                        continue;
                    }
                    if (!statusData.hasErrorMessage(field.getFieldName())) {
                        if (!fieldRequired || !StringUtils.isEmpty((String)currentValue) || errors.contains(this.requiredMessage)) continue;
                        errors.add(0, this.requiredMessage);
                        continue;
                    }
                    errors.addAll(this.getErrorMessages(statusData.getErrorMessages(field.getFieldName()), field));
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Error getting error messages for form " + form.getId() + ": "), (Throwable)e);
            }
        }
        return errors;
    }

    protected List getErrorMessages(List msgs, Field field) {
        if (CollectionUtils.isEmpty((Collection)msgs)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Object msg : msgs) {
            result.add(this.getErrorMessage((String)msg, field));
        }
        return result;
    }

    protected String getErrorMessage(String msg, Field field) {
        if (StringUtils.isEmpty((String)msg)) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        String label = field.getFieldName().indexOf(":decorator") > -1 ? (String)field.getLabel().get((Object)LocaleManager.currentLang()) : field.getFieldName();
        result.append(this.bundle.getString("error.start")).append(label).append(this.bundle.getString("error.end")).append(msg);
        return result.toString();
    }
}

