/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formProcessing;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeResponse;
import org.jbpm.formModeler.core.processing.formProcessing.SetFieldValueInstruction;
import org.jbpm.formModeler.core.processing.formProcessing.replacers.FormulaReplacementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasicFormChangeProcessor
extends FormChangeProcessor {
    private static transient Logger log = LoggerFactory.getLogger(BasicFormChangeProcessor.class);
    protected HashSet evaluatedFields = new HashSet();

    protected String replaceFieldValues(Form form, FormStatusData statusData, String namespace, Field field, String rangeFormula, Object loadedObject, FormChangeResponse response) {
        int beginIndex;
        int endIndex;
        while (rangeFormula.indexOf("{") != -1 && (endIndex = rangeFormula.indexOf("}", beginIndex = rangeFormula.indexOf("{"))) != -1) {
            String entityValue = rangeFormula.substring(beginIndex + 1, endIndex);
            Object value = this.evaluateEntityValue(form, namespace, entityValue, loadedObject, statusData, response);
            value = value == null ? "" : value;
            rangeFormula = rangeFormula.substring(0, beginIndex) + value + rangeFormula.substring(endIndex + 1);
        }
        return rangeFormula;
    }

    protected Object evaluateEntityValue(Form form, String namespace, String entityValue, Object loadedObject, FormStatusData statusData, FormChangeResponse response) {
        JXPathContext ctx;
        Field relatedField;
        String fieldName = entityValue;
        if (fieldName.indexOf("/") != -1) {
            fieldName = fieldName.substring(0, fieldName.indexOf("/"));
        }
        if ((relatedField = form.getField(fieldName)) != null && relatedField.getFieldFormula() != null && !"".equals(relatedField.getFieldFormula()) && !this.evaluatedFields.contains(fieldName)) {
            this.evaluateFormulaForField(form, namespace, relatedField, loadedObject, statusData, response, new Date());
        }
        Object value = null;
        if (loadedObject != null) {
            ctx = JXPathContext.newContext((Object)loadedObject);
            try {
                value = ctx.getValue(entityValue);
            }
            catch (Exception e) {
                log.debug("Error in JXPathContext ", (Throwable)e);
            }
        }
        if (statusData.getCurrentValues() != null) {
            ctx = JXPathContext.newContext((Object)statusData.getCurrentValues());
            try {
                value = statusData.getCurrentValues().containsKey(entityValue) ? statusData.getCurrentValues().get(entityValue) : ctx.getValue(entityValue);
            }
            catch (Exception e) {
                log.debug("Error in JXPathContext ", (Throwable)e);
            }
        }
        if (value instanceof String) {
            value = "\"" + StringEscapeUtils.escapeJava((String)((String)value)) + "\"";
        }
        if (value instanceof Date) {
            value = "new java.util.Date(" + ((Date)value).getTime() + "l)";
        }
        if (value == null) {
            // empty if block
        }
        return value;
    }

    protected void evaluateFormulaForField(Form form, String namespace, Field field, Object loadedObject, FormStatusData statusData, FormChangeResponse response, Date date) {
        this.evaluatedFields.add(field.getFieldName());
        if (field.getFieldFormula() != null && field.getFieldFormula().startsWith("=")) {
            Object value = this.evaluateFormula(form, namespace, field.getFieldFormula().substring(1), loadedObject, statusData, response, field, date);
            FormStatusData status1 = this.formProcessor.read(form, namespace);
            Object currentFieldValue = status1.getCurrentValue(field.getFieldName());
            if (currentFieldValue != null && value == null || value != null && !value.equals(currentFieldValue)) {
                FieldHandler fieldHandler = this.fieldHandlersManager.getHandler(field.getFieldType());
                Map fieldValuesMap = fieldHandler.getParamValue(namespace + "-" + form.getId() + "-" + field.getFieldName(), value, field.getFieldPattern());
                this.formProcessor.setValues(form, namespace, fieldValuesMap, fieldValuesMap, true);
                response.addInstruction(new SetFieldValueInstruction(fieldValuesMap));
            }
        }
    }

    protected Object evaluateFormula(Form form, String namespace, String formula, Object loadedObject, FormStatusData statusData, FormChangeResponse response, Field field, Date date) {
        if (log.isDebugEnabled()) {
            log.debug("Evaluating formula " + formula);
        }
        FormulaReplacementContext ctx = new FormulaReplacementContext();
        ctx.setBeforeFieldEvaluation(false);
        ctx.setDate(date);
        ctx.setField(field);
        ctx.setFormula(formula);
        ctx.setNamespace(namespace);
        String paramValue = "";
        FieldHandler manager = this.fieldHandlersManager.getHandler(field.getFieldType());
        String fieldId = namespace + "-" + form.getId() + "-" + field.getFieldName();
        try {
            String[] paramValues;
            Map parametersMap = statusData.getCurrentInputValues();
            Object value = manager.getValue(field, fieldId, parametersMap == null ? Collections.EMPTY_MAP : parametersMap, Collections.EMPTY_MAP, field.getFieldType().getFieldClass(), statusData.getCurrentValue(field.getFieldName()));
            Map params = manager.getParamValue(fieldId, value, field.getFieldPattern());
            if (params != null && (paramValues = (String[])params.get(fieldId)) != null && paramValues.length > 0) {
                paramValue = paramValues[0];
            }
        }
        catch (Exception e) {
            log.debug("Error: ", (Throwable)e);
        }
        ctx.setParamValue(paramValue == null ? "" : paramValue);
        String modifiedFormula = this.replacementManager.replace(ctx);
        modifiedFormula = this.replaceFieldValues(form, statusData, namespace, field, modifiedFormula, loadedObject, response);
        Interpreter interpreter = this.getInterpreter(form, namespace);
        try {
            if (log.isDebugEnabled()) {
                log.debug("Interpreting formula: '" + modifiedFormula + "'");
            }
            if (this.functionsProvider != null) {
                this.functionsProvider.populate(interpreter);
            }
            ctx.populate(interpreter);
            Object result = interpreter.eval(modifiedFormula);
            return result;
        }
        catch (EvalError evalError) {
            log.debug("Error interpreting formula: " + (Object)((Object)evalError) + " will cause formula evaluation to fail quietly.");
            return null;
        }
    }

    protected Interpreter getInterpreter(Form form, String namespace) {
        Interpreter i = (Interpreter)this.formProcessor.getAttribute(form, namespace, "-jbpm-formulasInterpreter");
        if (i == null) {
            i = new Interpreter();
            this.formProcessor.setAttribute(form, namespace, "-jbpm-formulasInterpreter", (Object)i);
        }
        return i;
    }
}

