/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.fieldHandlers.SubformFieldHandler;
import org.jbpm.formModeler.core.rendering.SubformFinderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="org.jbpm.formModeler.core.processing.fieldHandlers.CreateDynamicObjectFieldHandler")
public class CreateDynamicObjectFieldHandler
extends SubformFieldHandler {
    private static transient Logger log = LoggerFactory.getLogger(CreateDynamicObjectFieldHandler.class);
    public static final String CODE = "subformMultiple";
    @Inject
    private SubformFinderService subformFinderService;

    public CreateDynamicObjectFieldHandler() {
        this.setPageToIncludeForDisplaying("/formModeler/fieldHandlers/CreateDynamicObject/show.jsp");
        this.setPageToIncludeForRendering("/formModeler/fieldHandlers/CreateDynamicObject/input.jsp");
        this.setPageToIncludeForSearching("/formModeler/fieldHandlers/CreateDynamicObject/search.jsp");
    }

    @Override
    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        String[] editParams;
        boolean doSaveEdited;
        String[] createParams;
        boolean doCreate;
        String[] tableEnterMode = (String[])parametersMap.get(inputName + "." + "tableEnterMode");
        boolean doTableEnterMode = tableEnterMode != null && tableEnterMode.length == 1 && tableEnterMode[0].equals("true");
        String[] sCount = (String[])parametersMap.get(inputName + "." + "count");
        int count = sCount != null && sCount.length == 1 ? Integer.valueOf(sCount[0]) : 0;
        Form form = this.getTableDataForm(field, inputName);
        Object[] previousValuesMap = (Map[])previousValue;
        if (doTableEnterMode && count > 0) {
            if (previousValuesMap == null) {
                previousValuesMap = new Map[count];
            }
            for (int i = 0; i < count; ++i) {
                String namespace = inputName + "." + i;
                this.getFormProcessor().setValues(form, namespace, parametersMap, filesMap);
                FormStatusData status = this.getFormProcessor().read(form, namespace);
                if (!status.isValid()) continue;
                Map objectCreated = this.getFormProcessor().getMapRepresentationToPersist(form, namespace);
                if (previousValuesMap[i] != null) {
                    previousValuesMap[i].putAll(objectCreated);
                    continue;
                }
                previousValuesMap[i] = objectCreated;
            }
        }
        boolean bl = doCreate = (createParams = (String[])parametersMap.get(inputName + "." + "create")) != null && createParams.length == 1 && createParams[0].equals("true");
        if (doCreate) {
            Form createForm = this.getCreateForm(field, inputName);
            boolean addItemEnabled = Boolean.TRUE.equals(this.getFormProcessor().getAttribute(createForm, inputName, "-jbpm-doTheItemAdd"));
            if (addItemEnabled) {
                this.getFormProcessor().setValues(createForm, inputName + "." + "create", parametersMap, filesMap);
                FormStatusData status = this.getFormProcessor().read(createForm, inputName + "." + "create");
                if (status.isValid()) {
                    Map objectCreated = this.getFormProcessor().getMapRepresentationToPersist(createForm, inputName + "." + "create");
                    if (previousValuesMap == null) {
                        previousValuesMap = new Map[]{};
                    }
                    previousValuesMap = (Map[])ArrayUtils.add((Object[])previousValuesMap, (Object)objectCreated);
                    Form parentForm = field.getForm();
                    String parentNamespace = this.getNamespaceManager().getParentNamespace(inputName);
                    Set expandedFields = (Set)this.getFormProcessor().getAttribute(parentForm, parentNamespace, "-jbpm-expandedFields");
                    if (expandedFields != null) {
                        expandedFields.remove(field.getFieldName());
                        this.getFormProcessor().setAttribute(parentForm, parentNamespace, "-jbpm-expandedFields", (Object)expandedFields);
                    }
                    this.getFormProcessor().clear(form, parentNamespace);
                }
            }
        }
        boolean bl2 = doSaveEdited = (editParams = (String[])parametersMap.get(inputName + "." + "saveEdited")) != null && editParams.length == 1 && editParams[0].equals("true");
        if (doSaveEdited) {
            Form parentForm = field.getForm();
            String parentNamespace = this.getNamespaceManager().getParentNamespace(inputName);
            Map expandedFields = (Map)this.getFormProcessor().getAttribute(parentForm, parentNamespace, "-jbpm-editFieldPositions");
            if (expandedFields != null && !expandedFields.isEmpty()) {
                Integer positionStr = (Integer)expandedFields.get(field.getFieldName());
                int position = positionStr;
                Form editForm = this.getEditForm(field, inputName);
                this.getFormProcessor().setValues(editForm, inputName, parametersMap, filesMap);
                FormStatusData status = this.getFormProcessor().read(editForm, inputName);
                if (status.isValid()) {
                    Map objectCreated = this.getFormProcessor().getMapRepresentationToPersist(editForm, inputName);
                    previousValuesMap[position].putAll(objectCreated);
                    this.getFormProcessor().clear(editForm, inputName);
                    expandedFields.remove(field.getFieldName());
                    this.getFormProcessor().setAttribute(parentForm, parentNamespace, "-jbpm-editFieldPositions", (Object)expandedFields);
                }
            }
        }
        return previousValuesMap;
    }

    @Override
    public Map getParamValue(String inputName, Object value, String pattern) {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Object getStatusValue(Field field, String inputName, Object value) {
        if (value == null) {
            return new Map[0];
        }
        Form form = this.getEnterDataForm(inputName, field);
        DataHolder holder = (DataHolder)form.getHolders().iterator().next();
        List values = (List)value;
        Map[] result = new Map[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            try {
                Object val = values.get(i);
                HashMap inputData = new HashMap();
                if (!StringUtils.isEmpty((String)holder.getInputId())) {
                    inputData.put(holder.getInputId(), val);
                }
                HashMap outputData = new HashMap();
                if (!StringUtils.isEmpty((String)holder.getOuputId())) {
                    outputData.put(holder.getOuputId(), val);
                }
                result[i] = this.getFormProcessor().createFieldContextValueFromHolder(form, inputName, inputData, outputData, new HashMap(), holder);
                continue;
            }
            catch (Exception e) {
                log.error("Error getting status value for field: " + inputName, (Throwable)e);
            }
        }
        HashMap<String, Map[]> loadedObjects = new HashMap<String, Map[]>();
        loadedObjects.put(holder.getUniqeId(), result);
        this.getFormProcessor().read(form, inputName, null, loadedObjects);
        return result;
    }

    @Override
    public Object persist(Field field, String inputName) throws Exception {
        int i;
        FormStatusData data = this.getFormProcessor().read(field.getForm(), this.getNamespaceManager().getParentNamespace(inputName));
        Object objectValue = data.getCurrentValue(field.getFieldName());
        if (objectValue == null) {
            return null;
        }
        Form form = this.getEnterDataForm(inputName, field);
        DataHolder holder = (DataHolder)form.getHolders().iterator().next();
        List loadedObjects = (List)data.getLoadedObject(holder.getUniqeId());
        if (loadedObjects == null) {
            loadedObjects = Collections.EMPTY_LIST;
        }
        Map[] values = (Map[])objectValue;
        ArrayList<Object> result = new ArrayList<Object>();
        List removedValues = (List)data.getAttributes().get("-jbpm-removed-array-elements");
        if (removedValues == null) {
            removedValues = Collections.EMPTY_LIST;
        }
        for (i = 0; i < removedValues.size(); ++i) {
            Integer removed = (Integer)removedValues.get(i);
            if (removed >= loadedObjects.size()) continue;
            loadedObjects.remove(removed);
        }
        for (i = 0; i < values.length; ++i) {
            Object loadedObject = null;
            if (loadedObjects != null && loadedObjects.size() > i) {
                loadedObject = loadedObjects.get(i);
            }
            result.add(this.getFormProcessor().persistFormHolder(form, inputName, values[i], holder, loadedObject));
        }
        return result;
    }

    public Form calculateFieldForm(Field field, String formPath, String namespace) {
        if (StringUtils.isEmpty((String)formPath)) {
            formPath = field.getDefaultSubform();
        }
        return this.subformFinderService.getSubFormFromPath(formPath, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deleteElementInPosition(Form form, String namespace, String field, int position) {
        Form form2 = form;
        synchronized (form2) {
            FormStatusData statusData = this.getFormProcessor().read(form, namespace);
            Object[] previousValue = statusData.getCurrentValue(field);
            if (previousValue != null) {
                Object[] vals = previousValue;
                if (position < vals.length) {
                    previousValue = ArrayUtils.remove((Object[])vals, (int)position);
                } else {
                    log.error("Cannot delete position " + position + " in array with size " + vals.length);
                }
            } else {
                log.error("Cannot delete position " + position + " in null array.");
            }
            return previousValue;
        }
    }

    public Form getCreateForm(Field field, String namespace) {
        try {
            return this.calculateFieldForm(field, field.getDefaultSubform(), namespace);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return null;
        }
    }

    public Form getPreviewDataForm(Field field, String namespace) {
        try {
            return this.calculateFieldForm(field, field.getPreviewSubform(), namespace);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return null;
        }
    }

    public Form getTableDataForm(Field field, String namespace) {
        try {
            return this.calculateFieldForm(field, field.getTableSubform(), namespace);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return null;
        }
    }

    public Form getEditForm(Field field, String namespace) {
        try {
            return this.calculateFieldForm(field, field.getDefaultSubform(), namespace);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return null;
        }
    }
}

