/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.PersistentFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.subform.checkers.SubformChecker;
import org.jbpm.formModeler.core.processing.formRendering.FormErrorMessageBuilder;
import org.jbpm.formModeler.core.processing.formStatus.FormStatus;
import org.jbpm.formModeler.core.rendering.SubformFinderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="org.jbpm.formModeler.core.processing.fieldHandlers.SubformFieldHandler")
public class SubformFieldHandler
extends PersistentFieldHandler {
    private static transient Logger log = LoggerFactory.getLogger(SubformFieldHandler.class);
    @Inject
    private Instance<SubformChecker> checkers;
    private Set<SubformChecker> subformCheckers;
    @Inject
    private SubformFinderService subformFinderService;
    @Inject
    private FormErrorMessageBuilder formErrorMessageBuilder;
    @Inject
    private FormProcessor formProcessor;
    private static int maxDepth = 2;

    @PostConstruct
    public void prepare() {
        this.subformCheckers = new TreeSet<SubformChecker>(new Comparator<SubformChecker>(){

            @Override
            public int compare(SubformChecker o1, SubformChecker o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        for (SubformChecker p : this.checkers) {
            this.subformCheckers.add(p);
        }
    }

    public String[] getCompatibleClassNames() {
        return new String[]{Object.class.getName()};
    }

    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        Form form = this.getEnterDataForm(inputName, field);
        if (!SubformFieldHandler.checkSubformDepthAllowed(form, inputName)) {
            return null;
        }
        this.formProcessor.setValues(form, inputName, parametersMap, filesMap);
        FormStatusData status = this.formProcessor.read(form, inputName);
        if (status.isValid()) {
            if (status.isEmpty()) {
                return null;
            }
            Map m = this.formProcessor.getMapRepresentationToPersist(form, inputName);
            return m;
        }
        throw new IllegalArgumentException("Subform status is invalid.");
    }

    @Override
    public Object persist(Field field, String inputName) throws Exception {
        Form form = this.getEnterDataForm(inputName, field);
        Map representation = this.formProcessor.getMapRepresentationToPersist(form, inputName);
        DataHolder holder = (DataHolder)form.getHolders().iterator().next();
        FormStatus fs = this.getFormStatusManager().getFormStatus(form, inputName);
        Object locadedObject = fs.getLoadedObject(holder.getUniqeId());
        return this.formProcessor.persistFormHolder(form, inputName, representation, holder, locadedObject);
    }

    @Override
    public Object getStatusValue(Field field, String inputName, Object value) {
        if (value == null) {
            return Collections.EMPTY_MAP;
        }
        Form form = this.getEnterDataForm(inputName, field);
        DataHolder holder = (DataHolder)form.getHolders().iterator().next();
        HashMap<String, Object> inputData = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)holder.getInputId())) {
            inputData.put(holder.getInputId(), value);
        }
        HashMap<String, Object> outputData = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)holder.getInputId())) {
            outputData.put(holder.getOuputId(), value);
        }
        HashMap loadedObjects = new HashMap();
        Map result = null;
        try {
            result = this.formProcessor.readValuesToLoad(form, inputData, new HashMap(), loadedObjects, inputName);
        }
        catch (Exception e) {
            log.error("Error getting status value for field: " + inputName, (Throwable)e);
        }
        this.formProcessor.read(form, inputName, result, loadedObjects);
        return result;
    }

    public Map getParamValue(String inputName, Object value, String pattern) {
        if (value == null) {
            return Collections.EMPTY_MAP;
        }
        FormNamespaceData data = this.getNamespaceManager().getNamespace(inputName);
        Field parentField = data.getForm().getField(data.getFieldNameInParent());
        Form childForm = this.getEnterDataForm(inputName, parentField);
        HashMap result = new HashMap();
        DataHolder holder = (DataHolder)childForm.getHolders().iterator().next();
        for (Field childField : childForm.getFormFields()) {
            String bindingExpression = StringUtils.defaultIfEmpty((String)childField.getInputBinding(), (String)childField.getOutputBinding());
            if (!holder.isAssignableForField(childField)) continue;
            try {
                Object val = holder.readFromBindingExperssion(value, bindingExpression);
                FieldHandler fieldManager = this.getFieldHandlersManager().getHandler(childField.getFieldType());
                Map childrenMap = fieldManager.getParamValue(childField.getFieldName(), val, childField.getFieldPattern());
                if (childrenMap == null) continue;
                result.putAll(childrenMap);
            }
            catch (Exception e) {
                log.warn("Error reading value from field '" + childField.getFieldName() + "': ", (Throwable)e);
            }
        }
        return result;
    }

    public void addWrongChildFieldErrors(String namespace, Field field, List errors) {
        this.formErrorMessageBuilder.getWrongFormErrors(namespace, this.getEnterDataForm(namespace, field), errors);
    }

    public boolean isEmpty(Object value) {
        return value == null || "".equals(value);
    }

    protected Form getEnterDataForm(String namespace, Field field) {
        String formName = field.getDefaultSubform();
        return this.getForm(formName, namespace);
    }

    private Form getForm(String formPath, String namespace) {
        return this.subformFinderService.getSubFormFromPath(formPath, namespace);
    }

    public static boolean checkSubformDepthAllowed(Form form, String namesapce) {
        StringTokenizer token = new StringTokenizer(namesapce, "-", false);
        String _id = form.getId().toString();
        int count = 0;
        while (token.hasMoreElements()) {
            String idToCompare = (String)token.nextElement();
            if (!idToCompare.equals(_id) || ++count < maxDepth) continue;
            return false;
        }
        return true;
    }

    public Set<SubformChecker> getSubformCheckers() {
        return this.subformCheckers;
    }
}

