/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.client.FormRenderContext;
import org.jbpm.formModeler.api.client.FormRenderContextManager;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.FieldHandlersManager;
import org.jbpm.formModeler.core.config.RangeProviderManager;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.PersistentFieldHandler;
import org.jbpm.formModeler.core.processing.ProcessingMessagedException;
import org.jbpm.formModeler.core.processing.fieldHandlers.NumericFieldHandler;
import org.jbpm.formModeler.core.processing.formProcessing.DefaultFormulaProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.FormChangeResponse;
import org.jbpm.formModeler.core.processing.formProcessing.FormProcessingContext;
import org.jbpm.formModeler.core.processing.formProcessing.FormulasCalculatorChangeProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.NamespaceManager;
import org.jbpm.formModeler.core.processing.formStatus.FormStatus;
import org.jbpm.formModeler.core.processing.formStatus.FormStatusManager;
import org.jbpm.formModeler.core.processing.impl.FormStatusDataImpl;
import org.jbpm.formModeler.core.util.BindingExpressionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FormProcessorImpl
implements FormProcessor,
Serializable {
    private Logger log = LoggerFactory.getLogger(FormProcessor.class);
    @Inject
    private FormulasCalculatorChangeProcessor formChangeProcessor;
    @Inject
    private RangeProviderManager rangeProviderManager;
    @Inject
    private DefaultFormulaProcessor defaultFormulaProcessor;
    @Inject
    private FieldHandlersManager fieldHandlersManager;
    @Inject
    private FormRenderContextManager formRenderContextManager;
    private BindingExpressionUtil bindingExpressionUtil = BindingExpressionUtil.getInstance();

    protected FormStatus getContextFormStatus(FormRenderContext context) {
        return FormStatusManager.lookup().getFormStatus(context.getForm(), context.getUID());
    }

    protected FormStatus getFormStatus(Form form, String namespace) {
        return this.getFormStatus(form, namespace, new HashMap<String, Object>(), new HashMap<String, Object>());
    }

    protected FormStatus getFormStatus(Form form, String namespace, Map<String, Object> currentValues, Map<String, Object> loadedObjects) {
        FormStatus formStatus = FormStatusManager.lookup().getFormStatus(form, namespace);
        return formStatus != null ? formStatus : this.createFormStatus(form, namespace, currentValues, loadedObjects);
    }

    protected boolean existsFormStatus(Form form, String namespace) {
        FormStatus formStatus = FormStatusManager.lookup().getFormStatus(form, namespace);
        return formStatus != null;
    }

    protected FormStatus createFormStatus(Form form, String namespace, Map currentValues, Map<String, Object> loadedObjects) {
        FormStatus fStatus = FormStatusManager.lookup().createFormStatus(form, namespace, currentValues);
        fStatus.setLoadedObjects(loadedObjects);
        this.setDefaultValues(form, namespace, currentValues);
        return fStatus;
    }

    protected void setDefaultValues(Form form, String namespace, Map currentValues) {
        if (form != null) {
            Set formFields = form.getFormFields();
            HashMap<String, Map> rangeFormulas = (HashMap<String, Map>)this.getAttribute(form, namespace, "-jbpm-rangeFormulas");
            if (rangeFormulas == null) {
                rangeFormulas = new HashMap<String, Map>();
                this.setAttribute(form, namespace, "-jbpm-rangeFormulas", rangeFormulas);
            }
            for (Field field : formFields) {
                String inputName = this.getPrefix(form, namespace) + field.getFieldName();
                try {
                    String rangeFormula = field.getRangeFormula();
                    if (rangeFormula == null || rangeFormula.trim().length() <= 0) continue;
                    rangeFormulas.put(field.getFieldName(), this.rangeProviderManager.getRangeValues(rangeFormula, namespace));
                }
                catch (Exception e) {
                    this.log.error("Error obtaining default values for " + inputName, (Throwable)e);
                }
            }
            this.defaultFormulaProcessor.process(FormProcessingContext.defaultFormulaProcessingContext(form, namespace), null);
        }
    }

    protected void destroyFormStatus(Form form, String namespace) {
        FormStatusManager.lookup().destroyFormStatus(form.getId(), namespace);
    }

    public void setValues(Form form, String namespace, Map parameterMap, Map filesMap) {
        this.setValues(form, namespace, parameterMap, filesMap, false);
    }

    public void setValues(Form form, String namespace, Map parameterMap, Map filesMap, boolean incremental) {
        if (form != null) {
            namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
            FormStatus formStatus = this.getFormStatus(form, namespace);
            if (incremental) {
                HashMap mergedParameterMap = new HashMap();
                if (formStatus.getLastParameterMap() != null) {
                    mergedParameterMap.putAll(formStatus.getLastParameterMap());
                }
                if (parameterMap != null) {
                    mergedParameterMap.putAll(parameterMap);
                }
                formStatus.setLastParameterMap(mergedParameterMap);
            } else {
                formStatus.setLastParameterMap(parameterMap);
            }
            String inputsPrefix = this.getPrefix(form, namespace);
            for (Field field : form.getFormFields()) {
                this.setFieldValue(field, formStatus, inputsPrefix, parameterMap, filesMap, incremental);
            }
        }
    }

    public void modify(Form form, String namespace, String fieldName, Object value) {
        FormStatus formStatus = this.getFormStatus(form, namespace);
        formStatus.getInputValues().put(fieldName, value);
        this.propagateChangesToParentFormStatuses(formStatus, fieldName, value);
    }

    public void setAttribute(Form form, String namespace, String attributeName, Object attributeValue) {
        if (form != null) {
            FormStatus formStatus = this.getFormStatus(form, namespace);
            formStatus.getAttributes().put(attributeName, attributeValue);
        }
    }

    public Object getAttribute(Form form, String namespace, String attributeName) {
        if (form != null) {
            FormStatus formStatus = this.getFormStatus(form, namespace);
            return formStatus.getAttributes().get(attributeName);
        }
        return null;
    }

    protected void setFieldValue(Field field, FormStatus formStatus, String inputsPrefix, Map parameterMap, Map filesMap, boolean incremental) {
        block11: {
            String fieldName = field.getFieldName();
            String inputName = inputsPrefix + fieldName;
            FieldHandler handler = this.fieldHandlersManager.getHandler(field.getFieldType());
            try {
                Object previousValue = formStatus.getInputValues().get(fieldName);
                boolean isRequired = field.getFieldRequired();
                Object value = null;
                boolean emptyNumber = false;
                try {
                    value = handler.getValue(field, inputName, parameterMap, filesMap, field.getFieldType().getFieldClass(), previousValue);
                }
                catch (NumericFieldHandler.EmptyNumberException ene) {
                    emptyNumber = true;
                }
                if (incremental && value == null && !emptyNumber) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Refusing to overwrite input value for parameter " + fieldName);
                    }
                    break block11;
                }
                formStatus.getInputValues().put(fieldName, value);
                try {
                    this.propagateChangesToParentFormStatuses(formStatus, fieldName, value);
                }
                catch (Exception e) {
                    this.log.debug("Can't propagate changes to parentFormStatuses: ", (Throwable)e);
                }
                boolean isEmpty = handler.isEmpty(value);
                if (isRequired && isEmpty && !incremental) {
                    this.log.debug("Missing required field " + fieldName);
                    formStatus.getWrongFields().add(fieldName);
                } else {
                    formStatus.removeWrongField(fieldName);
                }
            }
            catch (ProcessingMessagedException pme) {
                this.log.debug("Processing field: ", (Throwable)pme);
                formStatus.addErrorMessages(fieldName, pme.getMessages());
            }
            catch (Exception e) {
                this.log.debug("Error setting field value:", (Throwable)e);
                if (incremental) break block11;
                formStatus.getInputValues().put(fieldName, null);
                formStatus.getWrongFields().add(fieldName);
            }
        }
    }

    protected void propagateChangesToParentFormStatuses(FormStatus formStatus, String fieldName, Object value) {
        FormStatus parent = FormStatusManager.lookup().getParent(formStatus);
        if (parent != null) {
            String fieldNameInParent = NamespaceManager.lookup().getNamespace(formStatus.getNamespace()).getFieldNameInParent();
            Object valueInParent = parent.getInputValues().get(fieldNameInParent);
            if (valueInParent != null) {
                Integer pos;
                Map editFieldPositions;
                Map parentMapObjectRepresentation = null;
                if (valueInParent instanceof Map) {
                    parentMapObjectRepresentation = (Map)valueInParent;
                } else if (valueInParent instanceof Map[] && (editFieldPositions = (Map)parent.getAttributes().get("-jbpm-editFieldPositions")) != null && (pos = (Integer)editFieldPositions.get(fieldNameInParent)) != null) {
                    parentMapObjectRepresentation = ((Map[])valueInParent)[pos];
                }
                if (parentMapObjectRepresentation != null) {
                    parentMapObjectRepresentation.put(fieldName, value);
                    this.propagateChangesToParentFormStatuses(parent, fieldNameInParent, valueInParent);
                }
            }
        }
    }

    public FormStatusData read(String ctxUid) {
        FormStatusDataImpl data = null;
        try {
            boolean isNew;
            FormRenderContext context = this.formRenderContextManager.getFormRenderContext(ctxUid);
            if (context == null) {
                return null;
            }
            FormStatus formStatus = this.getContextFormStatus(context);
            boolean bl = isNew = formStatus == null;
            if (isNew) {
                formStatus = this.createContextFormStatus(context);
            }
            data = new FormStatusDataImpl(formStatus, isNew);
        }
        catch (Exception e) {
            this.log.error("Error: ", (Throwable)e);
        }
        return data;
    }

    protected FormStatus createContextFormStatus(FormRenderContext context) throws Exception {
        HashMap<String, Object> loadedObjects = new HashMap<String, Object>();
        Map values = this.readValuesToLoad(context.getForm(), context.getInputData(), context.getOutputData(), loadedObjects, context.getUID());
        return this.getFormStatus(context.getForm(), context.getUID(), values, loadedObjects);
    }

    public Map readValuesToLoad(Form form, Map inputData, Map outputData, Map loadedObjects, String namespace) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        Set fields = form.getFormFields();
        if (fields != null) {
            for (Field field : form.getFormFields()) {
                Object value;
                boolean hasOutput;
                String inputExperession = field.getInputBinding();
                String outputExpression = field.getOutputBinding();
                boolean hasInput = !StringUtils.isEmpty((String)inputExperession);
                boolean bl = hasOutput = !StringUtils.isEmpty((String)outputExpression);
                if (!hasInput && !hasOutput) continue;
                boolean readFromInput = hasInput && !hasOutput || hasInput && outputData.isEmpty();
                DataHolder dataHolder = form.getDataHolderByField(field);
                if (dataHolder == null) {
                    value = readFromInput ? this.getUnbindedFieldValue(field.getInputBinding(), inputData) : this.getUnbindedFieldValue(field.getOutputBinding(), outputData);
                } else {
                    Object loadedObject = loadedObjects.get(dataHolder.getUniqeId());
                    if (loadedObject == null) {
                        loadedObject = outputData.isEmpty() ? inputData.get(dataHolder.getInputId()) : outputData.get(dataHolder.getOuputId());
                        loadedObjects.put(dataHolder.getUniqeId(), loadedObject);
                    }
                    value = readFromInput ? this.getBindedValue(field, dataHolder, inputExperession, inputData, loadedObjects, namespace) : this.getBindedValue(field, dataHolder, outputExpression, outputData, loadedObjects, namespace);
                }
                values.put(field.getFieldName(), value);
            }
        }
        return values;
    }

    protected Object getUnbindedFieldValue(String bindingExpression, Map<String, Object> bindingData) {
        if (bindingExpression.indexOf("/") != -1) {
            try {
                String root = bindingExpression.substring(0, bindingExpression.indexOf("/"));
                String expression = bindingExpression.substring(root.length() + 1);
                Object object = bindingData.get(root);
                JXPathContext ctx = JXPathContext.newContext((Object)object);
                return ctx.getValue(expression);
            }
            catch (Exception e) {
                this.log.warn("Error getting value for xpath xpression '{}': {}", (Object)bindingExpression, (Object)e);
            }
        }
        return bindingData.get(bindingExpression);
    }

    protected Object getBindedValue(Field field, DataHolder holder, String bindingExpression, Map<String, Object> bindingData, Map loadedObjects, String namespace) {
        Object value = null;
        try {
            Object bindingValue = loadedObjects.get(holder.getUniqeId());
            if (bindingValue != null && holder.isAssignableValue(bindingValue)) {
                if (!loadedObjects.containsKey(holder.getUniqeId())) {
                    loadedObjects.put(holder.getUniqeId(), bindingValue);
                }
                value = holder.readFromBindingExperssion(bindingValue, bindingExpression);
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to read value from expression '" + bindingExpression + "'. Error: ", (Throwable)e);
            value = bindingData.get(bindingExpression);
        }
        FieldHandler handler = this.fieldHandlersManager.getHandler(field.getFieldType());
        if (handler instanceof PersistentFieldHandler) {
            String inputName = this.getPrefix(field.getForm(), namespace) + field.getFieldName();
            value = ((PersistentFieldHandler)handler).getStatusValue(field, inputName, value);
        }
        return value;
    }

    public FormStatusData read(Form form, String namespace, Map formValues) {
        return this.read(form, namespace, formValues, new HashMap<String, Object>());
    }

    public FormStatusData read(Form form, String namespace, Map<String, Object> formValues, Map<String, Object> loadedObjects) {
        boolean exists = this.existsFormStatus(form, namespace);
        if (formValues == null) {
            formValues = new HashMap<String, Object>();
        }
        FormStatus formStatus = this.getFormStatus(form, namespace, formValues, loadedObjects);
        FormStatusDataImpl data = null;
        try {
            data = new FormStatusDataImpl(formStatus, !exists);
        }
        catch (Exception e) {
            this.log.error("Error: ", (Throwable)e);
        }
        return data;
    }

    public FormStatusData read(Form form, String namespace) {
        return this.read(form, namespace, new HashMap());
    }

    public void flushPendingCalculations(Form form, String namespace) {
        if (this.formChangeProcessor != null) {
            this.formChangeProcessor.process(form, namespace, new FormChangeResponse());
        }
    }

    public void persist(String ctxUid) throws Exception {
        ctxUid = StringUtils.defaultIfEmpty((String)ctxUid, (String)"NS");
        this.persist(this.formRenderContextManager.getFormRenderContext(ctxUid));
    }

    public void persist(FormRenderContext context) throws Exception {
        Form form = context.getForm();
        Map mapToPersist = this.getFilteredMapRepresentationToPersist(form, context.getUID());
        Map result = context.getOutputData();
        for (String fieldName : mapToPersist.keySet()) {
            boolean simpleBinding;
            Field field = form.getField(fieldName);
            if (field == null) continue;
            DataHolder holder = form.getDataHolderByField(field);
            String bindingString = field.getOutputBinding();
            if (StringUtils.isEmpty((String)bindingString)) continue;
            Object value = this.persistField(field, mapToPersist, holder, context.getUID());
            boolean bl = simpleBinding = StringUtils.isEmpty((String)(bindingString = this.bindingExpressionUtil.extractBindingExpression(bindingString))) || bindingString.indexOf("/") == -1;
            if (holder == null || simpleBinding) {
                result.put(bindingString, value);
                continue;
            }
            String holderFieldId = bindingString.substring((holder.getOuputId() + "/").length());
            Object holderOutputValue = result.get(holder.getOuputId());
            if (holderOutputValue == null || !holder.isAssignableValue(holderOutputValue)) {
                holderOutputValue = context.getInputData().get(holder.getInputId());
                if (holderOutputValue == null || !holder.isAssignableValue(holderOutputValue)) {
                    holderOutputValue = holder.createInstance(context);
                }
                result.put(holder.getOuputId(), holderOutputValue);
            }
            holder.writeValue(holderOutputValue, holderFieldId, value);
        }
    }

    public Object persistFormHolder(Form form, String namespace, Map<String, Object> mapToPersist, DataHolder holder, Object loadedObject) throws Exception {
        if (holder == null) {
            return null;
        }
        if (loadedObject == null) {
            FormRenderContext context = this.formRenderContextManager.getRootContext(namespace);
            loadedObject = holder.createInstance(context);
        }
        for (String fieldName : mapToPersist.keySet()) {
            String bindingString;
            Field field = form.getField(fieldName);
            if (field == null || !holder.isAssignableForField(field) || StringUtils.isEmpty((String)(bindingString = field.getOutputBinding()))) continue;
            bindingString = this.bindingExpressionUtil.extractBindingExpression(bindingString);
            String holderFieldId = bindingString.substring(holder.getOuputId().length() + 1);
            Object value = this.persistField(field, mapToPersist, holder, namespace);
            holder.writeValue(loadedObject, holderFieldId, value);
        }
        return loadedObject;
    }

    protected Object persistField(Field field, Map<String, Object> mapToPersist, DataHolder holder, String namespace) throws Exception {
        boolean complexBinding;
        String bindingString = field.getOutputBinding();
        if (holder == null && !StringUtils.isEmpty((String)bindingString)) {
            return mapToPersist.get(field.getFieldName());
        }
        boolean bl = complexBinding = (bindingString = this.bindingExpressionUtil.extractBindingExpression(bindingString)).indexOf("/") > 0;
        if (complexBinding) {
            String holderId = bindingString.substring(0, bindingString.indexOf("/"));
            String holderFieldId = bindingString.substring(holderId.length() + 1);
            if (holder != null && !StringUtils.isEmpty((String)holderFieldId)) {
                FieldHandler handler = this.fieldHandlersManager.getHandler(field.getFieldType());
                if (handler instanceof PersistentFieldHandler) {
                    String inputName = this.getPrefix(field.getForm(), namespace) + field.getFieldName();
                    return ((PersistentFieldHandler)handler).persist(field, inputName);
                }
                return mapToPersist.get(field.getFieldName());
            }
        }
        return mapToPersist.get(field.getFieldName());
    }

    public Map getMapRepresentationToPersist(Form form, String namespace) throws Exception {
        namespace = StringUtils.defaultIfEmpty((String)namespace, (String)"NS");
        this.flushPendingCalculations(form, namespace);
        HashMap m = new HashMap();
        FormStatus formStatus = this.getFormStatus(form, namespace);
        if (!formStatus.getWrongFields().isEmpty()) {
            throw new IllegalArgumentException("Validation error.");
        }
        this.fillObjectValues(m, formStatus.getInputValues(), form);
        TreeSet s = (TreeSet)m.get("-jbpm-modifiedFieldNames");
        if (s == null) {
            s = new TreeSet();
            m.put("-jbpm-modifiedFieldNames", s);
        }
        s.addAll(form.getFieldNames());
        return m;
    }

    protected Map getFilteredMapRepresentationToPersist(Form form, String namespace) throws Exception {
        Map inputValues = this.getMapRepresentationToPersist(form, namespace);
        Map mapToPersist = this.filterMapRepresentationToPersist(inputValues);
        return mapToPersist;
    }

    public Map filterMapRepresentationToPersist(Map inputValues) throws Exception {
        HashMap filteredMap = new HashMap();
        Set keys = inputValues.keySet();
        for (String key : keys) {
            filteredMap.put(key, inputValues.get(key));
        }
        return filteredMap;
    }

    protected void fillObjectValues(Map obj, Map values, Form form) throws Exception {
        HashMap valuesToSet = new HashMap();
        for (String propertyName : values.keySet()) {
            Object propertyValue = values.get(propertyName);
            valuesToSet.put(propertyName, propertyValue);
        }
        obj.putAll(valuesToSet);
    }

    public void clear(FormRenderContext context) {
        this.clear(context.getForm(), context.getUID());
    }

    public void clear(String ctxUID) {
        this.clear(this.formRenderContextManager.getFormRenderContext(ctxUID));
    }

    public void clear(Form form, String namespace) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Clearing form status for form " + form.getName() + " with namespace '" + namespace + "'");
        }
        this.destroyFormStatus(form, namespace);
    }

    public void clearField(Form form, String namespace, String fieldName) {
        FormStatus formStatus = this.getFormStatus(form, namespace);
        formStatus.getInputValues().remove(fieldName);
    }

    public void clearFieldErrors(Form form, String namespace) {
        FormStatusManager.lookup().cascadeClearWrongFields(form.getId(), namespace);
    }

    public void forceWrongField(Form form, String namespace, String fieldName) {
        FormStatusManager.lookup().getFormStatus(form, namespace).getWrongFields().add(fieldName);
    }

    protected String getPrefix(Form form, String namespace) {
        return namespace + "-" + form.getId() + "-";
    }
}

