/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formRendering;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.api.model.FormDisplayInfo;
import org.jbpm.formModeler.core.FieldHandlersManager;
import org.jbpm.formModeler.core.FormCoreServices;
import org.jbpm.formModeler.core.UIDGenerator;
import org.jbpm.formModeler.core.config.FormManager;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormProcessingServices;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.formRendering.FieldI18nResourceObtainer;
import org.jbpm.formModeler.core.processing.formRendering.FormErrorMessageBuilder;
import org.jbpm.formModeler.core.processing.formRendering.FormRenderer;
import org.jbpm.formModeler.core.processing.formRendering.TemplateRenderingInstruction;
import org.jbpm.formModeler.service.annotation.config.Config;
import org.jbpm.formModeler.service.bb.mvc.components.handling.MessagesComponentHandler;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.Formatter;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="FormRenderingFormatter")
public class FormRenderingFormatter
extends Formatter {
    public static final String ATTR_FIELD = "_ddm_currentField";
    public static final String ATTR_NAMESPACE = "_ddm_currentNamespace";
    public static final String ATTR_VALUE = "_ddm_currentValue";
    public static final String ATTR_INPUT_VALUE = "_ddm_currentInputValue";
    public static final String ATTR_NAME = "_ddm_currentName";
    public static final String ATTR_FIELD_IS_WRONG = "_ddm_currentFieldIsWrong";
    public static final String ATTR_FORM_RENDER_MODE = "_ddm_current_renderMode";
    public static final String ATTR_VALUE_IS_DYNAMIC_OBJECT = "_ddm_valueIsObject";
    public static final String ATTR_VALUE_IS_DYNAMIC_OBJECT_ARRAY = "_ddm_valueIsObjectArray";
    public static final String ATTR_DYNAMIC_OBJECT_ID = "_ddm_currentValueIds";
    public static final String ATTR_DYNAMIC_OBJECT_ENTITY_NAME = "_ddm_currentValueEntityName";
    public static final String ATTR_FIELD_IS_READONLY = "_ddm_fieldIsReadonly";
    public static final String FIELD_CONTAINER_STYLE = "padding-top: 3px; padding-right:3px;";
    private Logger log = LoggerFactory.getLogger(FormRenderingFormatter.class);
    @Inject
    private FormErrorMessageBuilder formErrorMessageBuilder;
    @Inject
    protected FieldI18nResourceObtainer fieldI18nResourceObtainer;
    @Inject
    @Config(value="/formModeler/defaultFormErrors.jsp")
    private String errorsPage;
    private String[] formModes = new String[]{"form", "wysiwyg-form"};
    private String[] displayModes = new String[]{"display", "wysiwyg-display"};
    protected transient Form formToPaint;
    protected transient String namespace;
    protected transient String renderMode;
    protected transient Boolean isReadonly = Boolean.FALSE;
    protected transient FormStatusData formStatusData;

    public UIDGenerator getUidGenerator() {
        return UIDGenerator.lookup();
    }

    public FormManager getFormManager() {
        return FormCoreServices.lookup().getFormManager();
    }

    public FormProcessor getFormProcessor() {
        return FormProcessingServices.lookup().getFormProcessor();
    }

    public FieldHandlersManager getFieldHandlersManager() {
        return FormProcessingServices.lookup().getFieldHandlersManager();
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws FormatterException {
        Object formObject = this.getParameter("form");
        if (formObject == null) {
            this.log.error("Form not found");
            return;
        }
        this.formToPaint = (Form)formObject;
        this.renderMode = (String)this.getParameter("renderMode");
        String labelMode = (String)this.getParameter("labelMode");
        String reusingStatus = (String)this.getParameter("reuseStatus");
        String forceLabelModeParam = (String)this.getParameter("forceLabelMode");
        String displayModeParam = (String)this.getParameter("displayMode");
        String subForm = (String)this.getParameter("isSubForm");
        String multiple = (String)this.getParameter("isMultiple");
        Boolean readonly = (Boolean)this.getParameter("isReadonly");
        if (readonly != null) {
            this.isReadonly = readonly;
        }
        boolean isSubForm = subForm != null && Boolean.valueOf(subForm) != false;
        boolean isMultiple = multiple != null && Boolean.valueOf(multiple) != false;
        this.namespace = (String)this.getParameter("namespace");
        if (StringUtils.isEmpty((String)this.namespace)) {
            this.log.warn("Empty namespace is no longer permitted. Will use a default namespace value, for backwards compatibility", (Throwable)new Exception());
            this.namespace = "NS";
        } else if (!Character.isJavaIdentifierStart(this.namespace.charAt(0))) {
            this.log.warn("Namespace " + this.namespace + " starts with an illegal character. It may cause unexpected behaviour of form under IE.");
        }
        Object formValues = this.getParameter("formValues");
        if (formValues != null) {
            this.getFormProcessor().clear(this.formToPaint, this.namespace);
            this.getFormProcessor().read(this.formToPaint, this.namespace, (Map)formValues);
        }
        this.renderMode = this.renderMode == null ? "form" : this.renderMode;
        labelMode = labelMode == null ? "before" : labelMode;
        boolean reuseStatus = reusingStatus == null || Boolean.valueOf(reusingStatus) != false;
        boolean forceLabelMode = forceLabelModeParam != null && Boolean.valueOf(forceLabelModeParam) != false;
        this.namespace = this.namespace == null ? "" : this.namespace;
        try {
            String formLabelMode;
            if (this.log.isDebugEnabled()) {
                this.log.debug("Printing form " + this.formToPaint.getId() + ". Mode: " + this.renderMode + ".");
            }
            if (!((formLabelMode = this.formToPaint.getLabelMode()) == null || "".equals(formLabelMode) || "undefined".equals(formLabelMode) || forceLabelMode)) {
                labelMode = formLabelMode;
            }
            if (formValues != null) {
                this.getFormProcessor().clear(this.formToPaint, this.namespace);
                this.formStatusData = this.getFormProcessor().read(this.formToPaint, this.namespace, (Map)formValues);
            } else {
                this.formStatusData = this.getFormProcessor().read(this.formToPaint, this.namespace);
            }
            String displayMode = this.formToPaint.getDisplayMode();
            if (displayModeParam != null) {
                displayMode = displayModeParam;
            }
            FormDisplayInfo displayInfo = null;
            if (displayMode != null) {
                for (FormDisplayInfo info : this.formToPaint.getFormDisplayInfos()) {
                    if (!info.getDisplayMode().equals(displayMode)) continue;
                    displayInfo = info;
                    break;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("About to display form " + this.formToPaint.getId() + " in namespace " + this.namespace);
            }
            this.display(this.formToPaint, this.namespace, displayMode, displayInfo, this.renderMode, labelMode, isSubForm, isMultiple);
        }
        catch (Exception e) {
            this.log.error("Error:", (Throwable)e);
            throw new FormatterException("Error", (Throwable)e);
        }
    }

    protected void setFormFieldErrors(String namespace, Form form) {
        MessagesComponentHandler messagesComponentHandler = MessagesComponentHandler.lookup();
        if (namespace != null && form != null) {
            try {
                messagesComponentHandler.getErrorsToDisplay().addAll(this.formErrorMessageBuilder.getWrongFormErrors(namespace, form));
            }
            catch (Exception e) {
                this.log.error("Error getting error messages for object " + form.getId() + ": ", (Throwable)e);
            }
        }
    }

    protected void display(Form form, String namespace, String displayMode, FormDisplayInfo displayInfo, String renderMode, String labelMode, boolean isSubForm, boolean isMultiple) {
        if (!isSubForm || isSubForm && isMultiple) {
            this.setFormFieldErrors(namespace, form);
            this.includePage(this.errorsPage);
        }
        if (displayMode == null) {
            this.defaultDisplay(form, namespace, renderMode, labelMode, "default");
        } else if ("default".equals(displayMode)) {
            this.defaultDisplay(form, namespace, renderMode, labelMode, "default");
        } else if ("aligned".equals(displayMode)) {
            this.defaultDisplay(form, namespace, renderMode, labelMode, "aligned");
        } else if ("none".equals(displayMode)) {
            this.defaultDisplay(form, namespace, renderMode, labelMode, "none");
        } else if ("template".equals(displayMode)) {
            this.templateDisplay(form, namespace, renderMode);
        } else {
            this.log.error("Unsupported display mode.");
        }
    }

    public void afterRendering(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws FormatterException {
        super.afterRendering(httpServletRequest, httpServletResponse);
        if (("display".equals(this.renderMode) || "templateEdit".equals(this.renderMode)) && this.formToPaint != null) {
            this.getFormProcessor().clear(this.formToPaint, this.namespace);
        }
    }

    protected void templateDisplay(final Form form, final String namespace, final String renderMode) {
        List renderingInstructions = FormProcessingServices.lookup().getFormTemplateHelper().getRenderingInstructions(form.getFormTemplate());
        FormRenderer renderer = new FormRenderer(){

            @Override
            public void writeToOut(String text) {
                FormRenderingFormatter.this.writeToOut(text);
            }

            @Override
            public void renderField(String fieldName) {
                Field field = form.getField(fieldName);
                if (field != null) {
                    FormRenderingFormatter.this.setAttribute("field", field);
                    FormRenderingFormatter.this.renderFragment("beforeFieldInTemplateMode");
                    FormRenderingFormatter.this.renderField(field, namespace, renderMode);
                    FormRenderingFormatter.this.renderFragment("afterFieldInTemplateMode");
                } else {
                    FormRenderingFormatter.this.setAttribute("fieldName", fieldName);
                    FormRenderingFormatter.this.renderFragment("beforeFieldInTemplateMode");
                    FormRenderingFormatter.this.writeToOut("$field{" + fieldName + "}");
                    FormRenderingFormatter.this.renderFragment("afterFieldInTemplateMode");
                }
            }

            @Override
            public void renderLabel(String fieldName) {
                Field field = form.getField(fieldName);
                if (field != null) {
                    FormRenderingFormatter.this.renderFragment("beforeLabelInTemplateMode");
                    FormRenderingFormatter.this.renderLabel(field, namespace, renderMode);
                    FormRenderingFormatter.this.renderFragment("afterLabelInTemplateMode");
                } else {
                    FormRenderingFormatter.this.renderFragment("beforeLabelInTemplateMode");
                    FormRenderingFormatter.this.writeToOut("$label{" + fieldName + "}");
                    FormRenderingFormatter.this.renderFragment("afterLabelInTemplateMode");
                }
            }
        };
        for (int i = 0; i < renderingInstructions.size(); ++i) {
            TemplateRenderingInstruction instruction = (TemplateRenderingInstruction)renderingInstructions.get(i);
            instruction.doRender(renderer);
        }
        this.displayFooter(form);
    }

    protected void renderField(Field field, String namespace, String renderMode) {
        this.beforeRenderField(field, namespace, renderMode);
        boolean fieldHasErrors = this.formStatusData.getWrongFields().contains(field.getFieldName());
        String renderPage = "";
        FieldHandler fieldHandler = this.getFieldHandlersManager().getHandler(field.getFieldType());
        if (Arrays.asList(this.formModes).contains(renderMode)) {
            renderPage = fieldHandler.getPageToIncludeForRendering();
        } else if (Arrays.asList(this.displayModes).contains(renderMode)) {
            renderPage = fieldHandler.getPageToIncludeForDisplaying();
        }
        if (!"".equals(renderPage)) {
            boolean fieldRequired;
            Boolean fieldIsRequired = field.getFieldRequired();
            boolean bl = fieldRequired = fieldIsRequired != null && fieldIsRequired != false;
            if (fieldHasErrors) {
                this.renderFragment("beforeWrongField");
            }
            if (fieldRequired) {
                this.renderFragment("beforeRequiredField");
            }
            Object value = this.formStatusData.getCurrentValue(field.getFieldName());
            boolean isStringType = String.class.getName().equals(field.getFieldType().getFieldClass());
            if (value == null && isStringType) {
                Map currentInputValues = this.formStatusData.getCurrentInputValues();
                String[] values = null;
                if (currentInputValues != null) {
                    values = (String[])currentInputValues.get(namespace + "-" + field.getForm().getId() + "-" + field.getFieldName());
                }
                value = values != null && values.length > 0 ? values[0] : value;
            }
            this.setRenderingAttributes(field, namespace, value, this.formStatusData, fieldHasErrors);
            if (this.isReadonly.booleanValue()) {
                this.setAttribute(ATTR_FIELD_IS_READONLY, this.isReadonly);
            }
            this.includePage(renderPage);
            if (fieldRequired) {
                this.renderFragment("afterRequiredField");
            }
            if (fieldHasErrors) {
                this.renderFragment("afterWrongField");
            }
        } else if ("templateEdit".equals(renderMode)) {
            this.writeToOut("$field{" + field.getFieldName() + "}");
        } else {
            this.log.warn("Invalid render mode " + renderMode);
        }
        this.afterRenderField(field, namespace, renderMode);
    }

    protected void beforeRenderField(Field field, String namespace, String renderMode) {
        String uid = this.getFormManager().getUniqueIdentifier(field.getForm(), namespace, field, field.getFieldName());
        String fieldTypeCss = field.getFieldType().getCssStyle();
        String fieldCss = field.getCssStyle();
        Object overridenValue = this.getFormProcessor().getAttribute(field.getForm(), namespace, field.getFieldName() + ".cssStyle");
        String css = fieldTypeCss;
        if (!StringUtils.isEmpty((String)fieldCss)) {
            css = fieldCss;
        }
        if (overridenValue != null) {
            css = (String)overridenValue;
        }
        css = StringUtils.defaultString((String)css);
        css = StringUtils.remove((String)css, (char)' ');
        String styleToWrite = FIELD_CONTAINER_STYLE;
        StringTokenizer strtk = new StringTokenizer(css, ";");
        while (strtk.hasMoreTokens()) {
            String tk = strtk.nextToken();
            if (!"display:none".equals(tk)) continue;
            styleToWrite = tk;
            break;
        }
        this.writeToOut("<div style=\"" + styleToWrite + "\" id=\"" + uid + "_container\">");
    }

    protected void afterRenderField(Field field, String namespace, String renderMode) {
        this.writeToOut("</div>");
    }

    protected void renderLabel(Field field, String namespace, String renderMode) {
        this.beforeRenderLabel(field, namespace, renderMode);
        String inputId = field.getFieldType().getUniqueIdentifier(this.getUidGenerator().getUniqueIdentifiersPreffix(), namespace, field.getForm(), field, field.getFieldName());
        String labelCssStyle = null;
        String labelCssClass = null;
        try {
            labelCssStyle = field.getLabelCSSStyle();
            labelCssClass = field.getLabelCSSClass();
            Object style = this.getFormProcessor().getAttribute(field.getForm(), namespace, field.getFieldName() + ".labelCSSStyle");
            if (style != null) {
                labelCssStyle = style.toString();
            }
        }
        catch (Exception e) {
            this.log.error("Error: ", (Throwable)e);
        }
        if ("templateEdit".equals(renderMode)) {
            this.writeToOut("$label{" + field.getFieldName() + "}");
        } else {
            boolean fieldHasErrors = this.formStatusData.getWrongFields().contains(field.getFieldName());
            String label = this.fieldI18nResourceObtainer.getFieldLabel(field);
            Boolean fieldIsRequired = field.getFieldRequired();
            boolean fieldRequired = fieldIsRequired != null && fieldIsRequired != false && !"display".equals(fieldIsRequired);
            String labelValue = StringEscapeUtils.escapeHtml((String)StringUtils.defaultString((String)label));
            this.writeToOut("<span id=\"" + inputId + "_label\"");
            this.writeToOut(" class='dynInputStyle " + StringUtils.defaultString((String)labelCssClass) + "' ");
            if (labelCssStyle != null) {
                this.writeToOut(" style='" + labelCssStyle + "' ");
            }
            this.writeToOut(" >");
            if (fieldHasErrors) {
                this.writeToOut("<span class=\"skn-error\">");
            }
            if (!(StringUtils.isEmpty((String)inputId) || StringUtils.isEmpty((String)labelValue) || "display".equals(renderMode))) {
                this.writeToOut("<label for=\"" + StringEscapeUtils.escapeHtml((String)inputId) + "\">");
            }
            if (fieldRequired) {
                this.writeToOut("*");
            }
            this.writeToOut(labelValue);
            if (!(StringUtils.isEmpty((String)inputId) || StringUtils.isEmpty((String)labelValue) || "display".equals(renderMode))) {
                this.writeToOut("</label>");
            }
            if (fieldRequired) {
                this.renderFragment("afterRequiredLabel");
            }
            if (fieldHasErrors) {
                this.writeToOut("</span>");
            }
            this.writeToOut("</span>");
        }
        this.afterRenderLabel(field, namespace, renderMode);
    }

    protected void beforeRenderLabel(Field field, String namespace, String renderMode) {
        String uid = this.getFormManager().getUniqueIdentifier(field.getForm(), namespace, field, field.getFieldName());
        String fieldCss = field.getLabelCSSStyle();
        Object overridenValue = this.getFormProcessor().getAttribute(field.getForm(), namespace, field.getFieldName() + ".labelCSSStyle");
        String css = fieldCss;
        if (overridenValue != null) {
            css = (String)overridenValue;
        }
        css = StringUtils.defaultString((String)css);
        css = StringUtils.remove((String)css, (char)' ');
        String styleToWrite = FIELD_CONTAINER_STYLE;
        StringTokenizer strtk = new StringTokenizer(css, ";");
        while (strtk.hasMoreTokens()) {
            String tk = strtk.nextToken();
            if (!"display:none".equals(tk)) continue;
            styleToWrite = tk;
            break;
        }
        this.writeToOut("<div style=\"" + styleToWrite + "\" id=\"" + uid + "_label_container\">");
    }

    protected void afterRenderLabel(Field field, String namespace, String renderMode) {
        this.writeToOut("</div>");
    }

    protected void defaultDisplay(Form form, String namespace, String renderMode, String labelMode, String mode) {
        Set fields = form.getFormFields();
        ArrayList sortedFields = new ArrayList(fields);
        Collections.sort(sortedFields, new Field.Comparator());
        FormStatusData formStatusData = this.getFormProcessor().read(form, namespace);
        this.setAttribute("width", this.deduceWidthForForm(form, renderMode, labelMode, mode));
        this.renderFragment("outputStart");
        this.renderFragment("formHeader");
        ArrayList<BigInteger> colspans = new ArrayList<BigInteger>();
        ArrayList fieldGroups = new ArrayList();
        fieldGroups.add(new ArrayList());
        for (Field field : sortedFields) {
            ArrayList<Field> currentList = (ArrayList<Field>)fieldGroups.get(fieldGroups.size() - 1);
            if (!Boolean.TRUE.equals(field.getGroupWithPrevious())) {
                currentList = new ArrayList<Field>();
                fieldGroups.add(currentList);
            }
            currentList.add(field);
        }
        for (int i = 0; i < fieldGroups.size(); ++i) {
            List list = (List)fieldGroups.get(i);
            if (list.isEmpty()) continue;
            colspans.add(new BigInteger(String.valueOf(list.size())));
        }
        BigInteger mcm = this.calculateMCM(colspans);
        BigInteger max = this.calculateMax(colspans);
        ArrayList<Field> groupList = new ArrayList<Field>();
        boolean first = true;
        for (int i = 0; i < sortedFields.size(); ++i) {
            Field nextField;
            Field field = (Field)sortedFields.get(i);
            groupList.add(field);
            if (i < sortedFields.size() - 1 && (nextField = (Field)sortedFields.get(i + 1)).getGroupWithPrevious() != null && nextField.getGroupWithPrevious().booleanValue()) continue;
            if (i > 0 && "none".equals(mode)) {
                this.renderFragment("outputEnd");
                this.setAttribute("width", this.deduceWidthForForm(form, renderMode, labelMode, mode));
                this.renderFragment("outputStart");
            }
            this.defaultDisplayGroup(form, groupList, mcm.intValue(), max.intValue(), renderMode, labelMode, formStatusData, mode, namespace, i, first);
            groupList.clear();
            first = false;
        }
        this.displayFooter(form);
        this.renderFragment("outputEnd");
    }

    protected void displayFooter(Form form) {
        String displayMode = form.getDisplayMode();
        if ("form".equals(this.renderMode)) {
            String formRefresherFieldName = this.namespace + "-" + form.getId() + "-" + ":initialFormRefresher";
            this.setAttribute("name", formRefresherFieldName);
            this.setAttribute("uid", this.getUidGenerator().getUniqueIdentifiersPreffix() + "-" + formRefresherFieldName);
            if ("template".equals(displayMode)) {
                this.includePage("/formModeler/defaultFormFooter.jsp");
            } else {
                this.renderFragment("formFooter");
            }
        }
    }

    protected String deduceWidthForForm(Form form, String renderMode, String labelMode, String mode) {
        if ("template".equals(mode)) {
            return null;
        }
        if ("display".equals(renderMode)) {
            if ("none".equals(mode)) {
                return "";
            }
            return "100%";
        }
        return "1%";
    }

    protected void defaultDisplayGroup(Form form, List groupMembers, int maxCols, int maxMembers, String renderMode, String labelMode, FormStatusData formStatusData, String mode, String namespace, int position, boolean first) {
        int fieldColspan = maxCols / groupMembers.size();
        int fieldWidth = 100 * fieldColspan / maxCols;
        if ("aligned".equals(mode)) {
            fieldColspan = maxCols / maxMembers;
        }
        if ("none".equals(mode)) {
            fieldColspan = 1;
        }
        this.setAttribute("groupPosition", position);
        this.setAttribute("field", groupMembers.get(0));
        this.setAttribute("colspan", maxCols);
        this.setAttribute("isFirst", first);
        this.renderFragment("groupStart");
        for (int i = 0; i < groupMembers.size(); ++i) {
            if (i == groupMembers.size() - 1 && "aligned".equals(mode)) {
                fieldColspan = maxCols - i * maxCols / maxMembers;
                fieldWidth = 100 * fieldColspan / maxCols;
            }
            this.renderInputElement((Field)groupMembers.get(i), fieldColspan, fieldWidth, namespace, renderMode, labelMode, i);
        }
        this.setAttribute("field", groupMembers.get(groupMembers.size() - 1));
        this.setAttribute("colspan", maxCols);
        this.renderFragment("groupEnd");
    }

    protected void renderInputElement(Field field, int fieldColspan, int fieldWidth, String namespace, String renderMode, String labelMode, int index) {
        this.setAttribute("field", field);
        this.setAttribute("colspan", fieldColspan);
        this.setAttribute("width", fieldWidth);
        this.setAttribute("index", index);
        boolean labelInSameLine = "left".equals(labelMode) || "right".equals(labelMode);
        this.renderFragment("beforeInputElement");
        if (field.getFieldType().getCode().equals("CheckBox") && !"left".equals(labelMode)) {
            labelMode = "after";
            labelInSameLine = true;
        }
        if ("before".equals(labelMode) || "left".equals(labelMode)) {
            this.setAttribute("colspan", fieldColspan);
            this.setAttribute("width", fieldWidth);
            this.setBindingAttributes(field);
            this.renderFragment("beforeLabel");
            this.renderLabel(field, namespace, renderMode);
            this.renderFragment("afterLabel");
            if (!labelInSameLine) {
                this.renderFragment("lineBetweenLabelAndField");
            }
        }
        this.setAttribute("field", field);
        this.setAttribute("colspan", fieldColspan);
        this.setAttribute("width", fieldWidth);
        this.renderFragment("beforeField");
        this.renderField(field, namespace, renderMode);
        this.setAttribute("field", field);
        this.renderFragment("afterField");
        if ("after".equals(labelMode) || "right".equals(labelMode)) {
            if (!labelInSameLine) {
                this.renderFragment("lineBetweenLabelAndField");
            }
            this.setAttribute("colspan", fieldColspan);
            this.setAttribute("width", fieldWidth);
            this.setBindingAttributes(field);
            this.renderFragment("beforeLabel");
            this.renderLabel(field, namespace, renderMode);
            this.renderFragment("afterLabel");
        }
        this.setAttribute("field", field);
        this.renderFragment("afterInputElement");
    }

    private void setBindingAttributes(Field field) {
        boolean hasOutputBinding;
        DataHolder inputHolder = this.formToPaint.getDataHolderFromInputExpression(field.getInputBinding());
        boolean hasInputBinding = !StringUtils.isEmpty((String)field.getInputBinding());
        String color = "#444444";
        this.setAttribute("hasInputBinding", hasInputBinding);
        if (hasInputBinding) {
            this.setAttribute("inputBindingColor", inputHolder != null ? inputHolder.getRenderColor() : color);
        }
        DataHolder outputHolder = this.formToPaint.getDataHolderFromOutputExpression(field.getOutputBinding());
        boolean bl = hasOutputBinding = !StringUtils.isEmpty((String)field.getOutputBinding());
        if (hasOutputBinding && hasInputBinding) {
            if (inputHolder != null && inputHolder.equals(outputHolder)) {
                hasOutputBinding = false;
            } else if (inputHolder == null && outputHolder == null) {
                hasOutputBinding = false;
            }
        }
        this.setAttribute("hasOutputBinding", hasOutputBinding);
        if (hasOutputBinding) {
            this.setAttribute("outputBindingColor", outputHolder != null ? outputHolder.getRenderColor() : color);
        }
    }

    protected BigInteger calculateMCM(List colspans) {
        if (colspans == null || colspans.isEmpty()) {
            return new BigInteger("1");
        }
        if (colspans.size() == 1) {
            return (BigInteger)colspans.get(0);
        }
        if (colspans.size() == 2) {
            BigInteger b1 = (BigInteger)colspans.get(0);
            BigInteger b2 = (BigInteger)colspans.get(1);
            return b1.multiply(b2).divide(b1.gcd(b2));
        }
        int halfLength = colspans.size() / 2;
        List firstHalf = colspans.subList(0, halfLength);
        List secondHalf = colspans.subList(halfLength, colspans.size());
        BigInteger b1 = this.calculateMCM(firstHalf);
        BigInteger b2 = this.calculateMCM(secondHalf);
        return b1.multiply(b2).divide(b1.gcd(b2));
    }

    protected BigInteger calculateMax(List colspans) {
        BigInteger max = new BigInteger("0");
        for (int i = 0; i < colspans.size(); ++i) {
            BigInteger number = (BigInteger)colspans.get(i);
            max = max.compareTo(number) < 0 ? number : max;
        }
        return max;
    }

    protected void setRenderingAttributes(Field field, String namespace, Object value, FormStatusData formStatusData, boolean isWrongField) {
        String fieldName = namespace + "-" + field.getForm().getId() + "-" + field.getFieldName();
        this.setAttribute(ATTR_FIELD, field);
        this.setAttribute(ATTR_VALUE, value);
        this.setAttribute(ATTR_INPUT_VALUE, formStatusData.getCurrentInputValue(fieldName));
        this.setAttribute(ATTR_FIELD_IS_WRONG, isWrongField);
        this.setAttribute(ATTR_NAMESPACE, namespace);
        this.setAttribute(ATTR_NAME, fieldName);
        this.setAttribute(ATTR_VALUE_IS_DYNAMIC_OBJECT, false);
        this.setAttribute(ATTR_VALUE_IS_DYNAMIC_OBJECT_ARRAY, false);
        this.setAttribute(ATTR_DYNAMIC_OBJECT_ID, null);
        this.setAttribute(ATTR_DYNAMIC_OBJECT_ENTITY_NAME, null);
        this.setAttribute(ATTR_FORM_RENDER_MODE, this.renderMode);
    }
}

