/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.core.processing.fieldHandlers.SubformFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.subform.checkers.FormCheckResult;
import org.jbpm.formModeler.core.processing.fieldHandlers.subform.checkers.SubformChecker;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="SubformFormatter")
public class SubformFormatter
extends DefaultFieldHandlerFormatter {
    private static transient Logger log = LoggerFactory.getLogger(SubformFormatter.class);

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws FormatterException {
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(httpServletRequest);
        Field field = paramsReader.getCurrentField();
        Form form = paramsReader.getCurrentForm();
        Object value = paramsReader.getCurrentFieldValue();
        String fieldName = paramsReader.getCurrentFieldName();
        int position = paramsReader.getCurrentPosition();
        String namespace = paramsReader.getCurrentNamespace();
        Boolean isReadonly = paramsReader.isFieldReadonly();
        SubformFieldHandler fieldHandler = (SubformFieldHandler)this.getFieldHandlersManager().getHandler(field.getFieldType());
        Form enterDataForm = fieldHandler.getEnterDataForm(namespace, field);
        Set<SubformChecker> checkers = fieldHandler.getSubformCheckers();
        for (SubformChecker checker : checkers) {
            FormCheckResult result = checker.checkForm(enterDataForm);
            if (result.isValid()) continue;
            this.setAttribute("error", result.getMessageKey());
            this.renderFragment("renderError");
            return;
        }
        if (!SubformFieldHandler.checkSubformDepthAllowed(form, namespace)) {
            return;
        }
        this.setDefaultAttributes(field, form, namespace);
        this.setAttribute("valueObject", value);
        this.setAttribute("position", position);
        this.setAttribute("name", fieldName);
        this.setAttribute("uid", this.getFormManager().getUniqueIdentifier(form, namespace, field, fieldName));
        String height = field.getHeight() != null && !"".equals(field.getHeight()) ? field.getHeight() : "100";
        this.setAttribute("heightDesired", height);
        this.renderFragment("outputStart");
        String renderMode = paramsReader.getCurrentRenderMode();
        this.setAttribute("form", enterDataForm);
        this.setAttribute("namespace", namespace + "-" + form.getId() + "-" + field.getFieldName());
        this.setAttribute("uid", this.getFormManager().getUniqueIdentifier(form, namespace, field, fieldName));
        this.setAttribute("name", fieldName);
        this.setAttribute("renderMode", renderMode);
        if (isReadonly.booleanValue()) {
            this.setAttribute("readonly", isReadonly);
        }
        if (value != null) {
            this.setAttribute("formValues", value);
        }
        this.renderFragment("outputForm");
        this.renderFragment("outputEnd");
    }
}

