/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.FieldType;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.api.model.wrappers.I18nSet;
import org.jbpm.formModeler.core.FieldHandlersManager;
import org.jbpm.formModeler.core.FormCoreServices;
import org.jbpm.formModeler.core.config.FieldTypeManager;
import org.jbpm.formModeler.core.config.FormManager;
import org.jbpm.formModeler.core.processing.BindingManager;
import org.jbpm.formModeler.core.processing.FormProcessingServices;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.formProcessing.NamespaceManager;
import org.jbpm.formModeler.service.annotation.config.Config;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormaterTagDynamicAttributesInterpreter;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="DefaultFieldHandlerFormatter")
public abstract class DefaultFieldHandlerFormatter
extends Formatter {
    private Logger log = LoggerFactory.getLogger(DefaultFieldHandlerFormatter.class);
    @Inject
    @Config(value="128")
    protected int defaultMaxLength;
    @Inject
    @Config(value="25")
    protected int defaultSize;
    @Inject
    protected NamespaceManager namespaceManager;

    public FormManager getFormManager() {
        return FormCoreServices.lookup().getFormManager();
    }

    public FieldTypeManager getFieldTypeManager() {
        return FormCoreServices.lookup().getFieldTypeManager();
    }

    public FormProcessor getFormProcessor() {
        return FormProcessingServices.lookup().getFormProcessor();
    }

    public FieldHandlersManager getFieldHandlersManager() {
        return FormProcessingServices.lookup().getFieldHandlersManager();
    }

    protected void setDefaultAttributes(final Field field, final Form form, final String namespace) {
        this.setAttributeInterpreter(new FormaterTagDynamicAttributesInterpreter(){
            private BindingManager bindingManager = FormCoreServices.lookup().getBindingManager();

            public Object getValueForParameter(String parameter) {
                Object value = null;
                if ("form".equals(parameter)) {
                    value = form;
                }
                if ("field".equals(parameter)) {
                    value = field;
                }
                if (form != null && "lastParameterMap".equals(parameter)) {
                    value = DefaultFieldHandlerFormatter.this.getFormProcessor().read(form, namespace).getCurrentInputValues();
                }
                if (field != null && "name".equals(parameter)) {
                    value = field.getFieldName();
                }
                if (field != null && form != null) {
                    try {
                        Object val;
                        FieldType fieldType = field.getFieldType();
                        if (this.bindingManager.hasProperty((Object)fieldType, parameter)) {
                            val = this.bindingManager.getPropertyValue((Object)fieldType, parameter);
                            if ((val = DefaultFieldHandlerFormatter.this.getCustomValueIfApplicable(field, parameter, val, form, namespace)) != null) {
                                value = val;
                            }
                        }
                        if (this.bindingManager.hasProperty((Object)field, parameter)) {
                            val = this.bindingManager.getPropertyValue((Object)field, parameter);
                            if ((val = DefaultFieldHandlerFormatter.this.getCustomValueIfApplicable(field, parameter, val, form, namespace)) != null && !"".equals(val)) {
                                value = val;
                            }
                        }
                    }
                    catch (Exception e) {
                        DefaultFieldHandlerFormatter.this.log.error("Error calculating attribute " + parameter + " for field " + field.getFieldName());
                    }
                }
                return value;
            }
        });
    }

    protected Object getCustomValueIfApplicable(Field field, String propName, Object propValue, Form form, String namespace) {
        Object overridenValue;
        if ("title".equals(propName) || "label".equals(propName)) {
            if (propValue != null && propValue instanceof I18nSet) {
                String value = (String)this.getLocaleManager().localize((Map)((I18nSet)propValue));
                Object object = propValue = !"".equals(value) ? value : null;
            }
            if ("title".equals(propName)) {
                propValue = StringEscapeUtils.escapeHtml((String)StringUtils.defaultString((String)((String)propValue)));
            }
        }
        if ((overridenValue = this.getFormProcessor().getAttribute(form, namespace, field.getFieldName() + "." + propName)) != null) {
            propValue = overridenValue;
        }
        return propValue;
    }
}

