/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.core.processing.DefaultFieldHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="org.jbpm.formModeler.core.processing.fieldHandlers.DateFieldHandler")
public class DateFieldHandler
extends DefaultFieldHandler {
    private static transient Logger log = LoggerFactory.getLogger(DateFieldHandler.class);
    public static final String HAS_CHANGED_PARAM = "_hasChanged";
    public static final String DATE_PATTERN_SUFFIX = "_pattern";
    public static final Date DEFAULT_MIN_DATE = new Date(0L);
    protected String defaultPattern = "MM-dd-yyyy";
    protected String defaultPatterTimeSuffix = "HH:mm:ss";
    protected String defaultJQueryPattern = "mm-dd-yy";

    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        Object[] hasChangedParam = (String[])parametersMap.get(inputName + HAS_CHANGED_PARAM);
        try {
            boolean hasChanged = !ArrayUtils.isEmpty((Object[])hasChangedParam) && Boolean.TRUE.equals(Boolean.parseBoolean((String)hasChangedParam[0]));
            SimpleDateFormat sdf = this.getSimpleDateFormat(field, hasChanged, this.getFieldPattern(field));
            Object[] dateValue = (String[])parametersMap.get(inputName);
            if (!ArrayUtils.isEmpty((Object[])dateValue)) {
                return this.getTheDate((String[])dateValue, sdf);
            }
        }
        catch (ParseException e) {
            log.debug("Error:", (Throwable)e);
        }
        return previousValue;
    }

    public String[] getCompatibleClassNames() {
        return new String[]{Date.class.getName()};
    }

    public boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Object[]) {
            Object[] values = (Object[])value;
            for (int i = 0; i < values.length; ++i) {
                Object date = values[i];
                if (date == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getDefaultPattern() {
        return this.defaultPattern;
    }

    public void setDefaultPattern(String defaultPattern) {
        this.defaultPattern = defaultPattern;
    }

    public String getDefaultJQueryPattern() {
        return this.defaultJQueryPattern;
    }

    public void setDefaultJQueryPattern(String defaultJQueryPattern) {
        this.defaultJQueryPattern = defaultJQueryPattern;
    }

    protected String getPattern(Field field, boolean useDefault, String pattern) {
        if (!useDefault && field != null && !StringUtils.isEmpty((String)field.getPattern())) {
            pattern = field.getPattern();
        }
        return StringUtils.defaultString((String)pattern);
    }

    protected SimpleDateFormat getSimpleDateFormat(Field field, boolean useDefault, String pattern) {
        return new SimpleDateFormat(this.getPattern(field, useDefault, pattern));
    }

    public Object getTheDate(String[] values, SimpleDateFormat sdf) throws Exception {
        String date = !ArrayUtils.isEmpty((Object[])values) ? values[0] : null;
        return !StringUtils.isEmpty((String)date) ? sdf.parse(date) : null;
    }

    public Map getParamValue(Field field, String inputName, Object objectValue) {
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        if (objectValue != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(StringUtils.defaultString((String)this.getFieldPattern(field), (String)this.defaultPattern));
            m.put(inputName, new String[]{sdf.format(objectValue)});
        }
        return m;
    }

    public String getDefaultPatterTimeSuffix() {
        return this.defaultPatterTimeSuffix;
    }

    public void setDefaultPatterTimeSuffix(String defaultPatterTimeSuffix) {
        this.defaultPatterTimeSuffix = defaultPatterTimeSuffix;
    }
}

