/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.ArrayUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.api.model.wrappers.I18nSet;
import org.jbpm.formModeler.core.FieldHandlersManager;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.processing.FormProcessingServices;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.fieldHandlers.CreateDynamicObjectFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.subform.utils.SubFormHelper;
import org.jbpm.formModeler.core.processing.formProcessing.NamespaceManager;
import org.jbpm.formModeler.core.processing.formStatus.FormStatus;
import org.jbpm.formModeler.core.processing.formStatus.FormStatusManager;
import org.jbpm.formModeler.core.rendering.SubformFinderService;
import org.jbpm.formModeler.service.bb.mvc.components.handling.BeanHandler;
import org.jbpm.formModeler.service.bb.mvc.controller.CommandRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Named(value="org.jbpm.formModeler.core.processing.fieldHandlers.SubFormSendHandler")
public class SubFormSendHandler
extends BeanHandler {
    private Logger log = LoggerFactory.getLogger(SubFormSendHandler.class);
    @Inject
    private SubformFinderService subformFinderService;
    @Inject
    private SubFormHelper helper;

    public NamespaceManager getNamespaceManager() {
        return NamespaceManager.lookup();
    }

    public FormProcessor getFormProcessor() {
        return FormProcessingServices.lookup().getFormProcessor();
    }

    public FormStatusManager getFormStatusManager() {
        return FormStatusManager.lookup();
    }

    public FieldHandlersManager getFieldHandlersManager() {
        return FormProcessingServices.lookup().getFieldHandlersManager();
    }

    public void actionExpandSubform(CommandRequest request) {
        this.log.debug("Expanding subform");
        Enumeration parameterNames = request.getRequestObject().getParameterNames();
        while (parameterNames.hasMoreElements()) {
            FieldHandler handler;
            FormStatus formStatus;
            String parameterValue;
            String parameterName = (String)parameterNames.nextElement();
            if (!parameterName.endsWith(".expand") || !"true".equals(parameterValue = request.getParameter(parameterName)) && !"false".equals(parameterValue)) continue;
            boolean expand = Boolean.valueOf(parameterValue);
            FormNamespaceData fsd = this.getNamespaceManager().getNamespace(parameterName);
            this.getFormProcessor().setValues(fsd.getForm(), fsd.getNamespace(), request.getRequestObject().getParameterMap(), request.getFilesByParamName());
            String fieldName = fsd.getFieldNameInParent();
            fieldName = fieldName.substring(0, fieldName.length() - ".create".length());
            Field field = fsd.getForm().getField(fieldName);
            String inputName = this.getNamespaceManager().generateFieldNamesPace(fsd.getNamespace(), field);
            if (expand) {
                this.helper.setExpandedField(inputName, inputName);
            } else {
                this.helper.clearExpandedField(inputName);
            }
            if (expand && (formStatus = this.getFormStatusManager().getFormStatus(fsd.getForm(), fsd.getNamespace())) != null) {
                formStatus.removeWrongField(fieldName);
            }
            if ((handler = this.getFieldHandlersManager().getHandler(field.getFieldType())) instanceof CreateDynamicObjectFieldHandler) {
                CreateDynamicObjectFieldHandler fHandler = (CreateDynamicObjectFieldHandler)handler;
                Form createForm = fHandler.getCreateForm(field, fsd.getNamespace());
                String createFormNamespace = fsd.getNamespace() + "-" + fsd.getForm().getId() + "-" + fieldName + "." + "create";
                this.getFormProcessor().clear(createForm, createFormNamespace);
                this.log.debug("Cleared subform status");
            } else {
                this.log.error("Can't clear subform to unknown field type: " + handler.getClass().getName());
            }
            this.getFormProcessor().clearFieldErrors(fsd.getForm(), fsd.getNamespace());
            break;
        }
    }

    public void actionAddItem(CommandRequest request) {
        this.log.debug("Adding item to subform");
        Set s = this.getFormNamespaceDatas(request, ".create");
        for (FormNamespaceData formData : s) {
            String fieldName = formData.getFieldNameInParent();
            fieldName = fieldName.substring(0, fieldName.length() - ".create".length());
            Field field = formData.getForm().getField(fieldName);
            FieldHandler handler = this.getFieldHandlersManager().getHandler(field.getFieldType());
            if (handler instanceof CreateDynamicObjectFieldHandler) {
                CreateDynamicObjectFieldHandler fHandler = (CreateDynamicObjectFieldHandler)handler;
                Form createForm = fHandler.getCreateForm(field, formData.getNamespace());
                String createFormNamespace = formData.getNamespace() + "-" + formData.getForm().getId() + "-" + fieldName;
                this.getFormProcessor().setAttribute(createForm, createFormNamespace, "-jbpm-doTheItemAdd", (Object)Boolean.TRUE);
                this.getFormProcessor().setValues(formData.getForm(), formData.getNamespace(), request.getRequestObject().getParameterMap(), request.getFilesByParamName());
                FormStatusData createStatus = this.getFormProcessor().read(createForm, createFormNamespace + "." + "create");
                boolean operationSuccess = createStatus.isValid();
                if (operationSuccess) {
                    this.getFormProcessor().clearFieldErrors(formData.getForm(), formData.getNamespace());
                    this.getFormProcessor().clear(createForm, createFormNamespace + "." + "create");
                } else {
                    List wrongFields = createStatus.getWrongFields();
                    this.getFormProcessor().clearFieldErrors(formData.getForm(), formData.getNamespace());
                    for (int i = 0; i < wrongFields.size(); ++i) {
                        String fieldNameToMarkAsWrong = (String)wrongFields.get(i);
                        this.getFormProcessor().forceWrongField(createForm, createFormNamespace + "." + "create", fieldNameToMarkAsWrong);
                    }
                }
                this.getFormProcessor().setAttribute(createForm, createFormNamespace, "-jbpm-doTheItemAdd", (Object)Boolean.FALSE);
                this.log.debug("Item added to subform");
                continue;
            }
            this.log.error("Can't add item to unknown field type: " + handler.getClass().getName());
        }
    }

    public void actionDeleteItem(CommandRequest request) throws Exception {
        String[] uids = request.getRequestObject().getParameterValues("child_uid_value");
        String uid = "";
        if (uids != null) {
            for (int i = 0; i < uids.length; ++i) {
                if (uids[i] == null || "".equals(uids[i])) continue;
                uid = uids[i];
            }
        }
        String sIndex = request.getParameter(uid + "_index");
        String parentFormId = request.getParameter(uid + "_parentFormId");
        String parentNamespace = request.getParameter(uid + "_parentNamespace");
        String fieldName = request.getParameter(uid + "_field");
        String inputName = request.getParameter(uid + "_inputName");
        Form parentForm = this.subformFinderService.getFormById(Long.decode(parentFormId).longValue(), parentNamespace);
        this.getFormProcessor().setValues(parentForm, parentNamespace, request.getRequestObject().getParameterMap(), request.getFilesByParamName());
        Field field = parentForm.getField(fieldName);
        FieldHandler handler = this.getFieldHandlersManager().getHandler(field.getFieldType());
        if (handler instanceof CreateDynamicObjectFieldHandler) {
            CreateDynamicObjectFieldHandler fHandler = (CreateDynamicObjectFieldHandler)handler;
            int index = Integer.decode(sIndex);
            Object deletedResultValue = fHandler.deleteElementInPosition(parentForm, parentNamespace, fieldName, index);
            List<Integer> removedValues = this.helper.getRemovedFieldPositions(inputName);
            if (removedValues == null) {
                removedValues = new ArrayList<Integer>();
                this.helper.setRemovedFieldPositions(inputName, removedValues);
            }
            removedValues.add(index);
            this.getFormProcessor().modify(parentForm, parentNamespace, fieldName, deletedResultValue);
        } else {
            this.log.error("Cannot delete value in a field which is not a CreateDynamicObjectFieldHandler.");
        }
        this.getFormProcessor().clearFieldErrors(parentForm, parentNamespace);
    }

    public void actionEditItem(CommandRequest request) throws Exception {
        this.editItem(request, true);
    }

    public void actionSaveEditedItem(CommandRequest request) {
        this.log.debug("Saving edited item in subform");
        Set s = this.getFormNamespaceDatas(request, ".saveEdited");
        for (FormNamespaceData formData : s) {
            this.getFormProcessor().setValues(formData.getForm(), formData.getNamespace(), request.getRequestObject().getParameterMap(), request.getFilesByParamName(), true);
        }
        this.log.debug("Item from subform, saved");
    }

    public void actionCancelEditItem(CommandRequest request) throws Exception {
        this.editItem(request, false);
    }

    public void actionPreviewItem(CommandRequest request) throws Exception {
        this.previewItem(request, true);
    }

    public void actionCancelPreviewItem(CommandRequest request) throws Exception {
        this.previewItem(request, false);
    }

    public void previewItem(CommandRequest request, boolean doIt) throws Exception {
        String[] uids = request.getRequestObject().getParameterValues("child_uid_value");
        String uid = "";
        if (uids != null) {
            for (int i = 0; i < uids.length; ++i) {
                if (uids[i] == null || "".equals(uids[i])) continue;
                uid = uids[i];
            }
        }
        String index = request.getParameter(uid + "_index");
        String parentFormId = request.getParameter(uid + "_parentFormId");
        String parentNamespace = request.getParameter(uid + "_parentNamespace");
        String inputName = request.getParameter(uid + "_inputName");
        Form form = this.subformFinderService.getFormById(Long.decode(parentFormId).longValue(), parentNamespace);
        this.getFormProcessor().setValues(form, parentNamespace, request.getRequestObject().getParameterMap(), request.getFilesByParamName());
        if (doIt) {
            this.helper.setPreviewFieldPosition(inputName, Integer.decode(index));
        } else {
            this.helper.clearPreviewFieldPositions(inputName);
        }
        this.getFormProcessor().clearFieldErrors(form, parentNamespace);
    }

    public void editItem(CommandRequest request, boolean doIt) throws Exception {
        String[] uids = request.getRequestObject().getParameterValues("child_uid_value");
        String uid = "";
        if (uids != null) {
            for (int i = 0; i < uids.length; ++i) {
                if (uids[i] == null || "".equals(uids[i])) continue;
                uid = uids[i];
            }
        }
        String index = request.getParameter(uid + "_index");
        String parentFormId = request.getParameter(uid + "_parentFormId");
        String parentNamespace = request.getParameter(uid + "_parentNamespace");
        String fieldName = request.getParameter(uid + "_field");
        String inputName = request.getParameter(uid + "_inputName");
        Form form = this.subformFinderService.getFormById(Long.decode(parentFormId).longValue(), parentNamespace);
        Field field = form.getField(fieldName);
        this.getFormProcessor().setValues(form, parentNamespace, request.getRequestObject().getParameterMap(), request.getFilesByParamName());
        if (doIt) {
            FormStatusData fsd = this.getFormProcessor().read(form, parentNamespace);
            Map[] previousValue = this.deepCloneOfMapArray((Map[])fsd.getCurrentValue(fieldName), new HashMap());
            this.helper.setEditFieldPreviousValues(inputName, previousValue);
            CreateDynamicObjectFieldHandler fieldHandler = (CreateDynamicObjectFieldHandler)this.getFieldHandlersManager().getHandler(field.getFieldType());
            Form formToEdit = fieldHandler.getEditForm(field, parentNamespace);
            this.getFormProcessor().clear(formToEdit, parentNamespace + "-" + parentFormId + "-" + fieldName + "." + index);
            this.getFormProcessor().clear(formToEdit, parentNamespace + "-" + parentFormId + "-" + fieldName);
            this.helper.setEditFieldPosition(inputName, Integer.decode(index));
        } else {
            Object previousValue = this.helper.getEditFieldPreviousValues(inputName);
            this.getFormProcessor().modify(form, parentNamespace, fieldName, previousValue);
            this.helper.clearExpandedField(inputName);
            this.helper.clearEditFieldPositions(inputName);
            this.helper.clearEditFieldPreviousValues(inputName);
            this.helper.clearPreviewFieldPositions(inputName);
        }
        this.getFormProcessor().clearFieldErrors(form, parentNamespace);
    }

    protected Map[] deepCloneOfMapArray(Map[] maparray, Map cache) {
        if (maparray == null || maparray.length == 0) {
            return maparray;
        }
        Object[] clone = new Map[]{};
        for (int i = 0; i < maparray.length; ++i) {
            Map map = maparray[i];
            Map cloneMap = this.deepCloneOfMap(map, cache);
            clone = (Map[])ArrayUtils.add((Object[])clone, (Object)cloneMap);
        }
        return clone;
    }

    protected Map deepCloneOfMap(Map map, Map cache) {
        if (map == null) {
            return null;
        }
        if (map instanceof I18nSet) {
            return map;
        }
        HashMap clone = new HashMap();
        Set keys = map.keySet();
        for (Object key : keys) {
            Object value = map.get(key);
            if (value == null) {
                clone.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                clone.put(key, this.deepCloneOfMap((Map)value, cache));
                continue;
            }
            if (value instanceof Map[]) {
                clone.put(key, this.deepCloneOfMapArray((Map[])value, cache));
                continue;
            }
            clone.put(key, value);
        }
        return clone;
    }

    protected Set getFormNamespaceDatas(CommandRequest request, String action) {
        HashSet<FormNamespaceData> s = new HashSet<FormNamespaceData>();
        Enumeration en = request.getRequestObject().getParameterNames();
        while (en.hasMoreElements()) {
            FormNamespaceData fsd;
            String paramName = (String)en.nextElement();
            String paramValue = request.getParameter(paramName);
            if (!"true".equals(paramValue) || !paramName.endsWith(action) || (fsd = this.getNamespaceManager().getNamespace(paramName)) == null) continue;
            s.add(fsd);
        }
        return s;
    }

    public boolean isEnabledForActionHandling() {
        return true;
    }
}

