/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.model.FieldType;
import org.jbpm.formModeler.core.FieldHandlersManager;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.CheckBoxFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.DateFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.HTMLTextAreaFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.HTMLi18nFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.I18nSetFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.I18nTextAreaFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.InputTextFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.NumericFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.ShortDateFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.SubformFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.TextAreaFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.multipleSubform.CreateDynamicObjectFieldHandler;
import org.jbpm.formModeler.core.processing.formDecorators.HTMLlabel;
import org.jbpm.formModeler.core.processing.formDecorators.Separator;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;

@ApplicationScoped
public class FieldHandlersManagerImpl
implements FieldHandlersManager {
    private List<FieldHandler> handlers;
    private List<FieldHandler> decorators;

    @PostConstruct
    protected void init() {
        this.handlers = new ArrayList<FieldHandler>();
        this.handlers.add(new InputTextFieldHandler());
        this.handlers.add(new NumericFieldHandler());
        this.handlers.add(new TextAreaFieldHandler());
        this.handlers.add(new DateFieldHandler());
        this.handlers.add(new ShortDateFieldHandler());
        this.handlers.add(new CheckBoxFieldHandler());
        this.handlers.add(new I18nSetFieldHandler());
        this.handlers.add(new I18nTextAreaFieldHandler());
        this.handlers.add(new HTMLTextAreaFieldHandler());
        this.handlers.add(new HTMLi18nFieldHandler());
        this.decorators = new ArrayList<FieldHandler>();
        this.decorators.add(new HTMLlabel());
        this.decorators.add(new Separator());
        this.decorators.add(new SubformFieldHandler());
        this.decorators.add(new CreateDynamicObjectFieldHandler());
    }

    @Override
    public List<FieldHandler> getDecorators() {
        return this.decorators;
    }

    @Override
    public List<FieldHandler> getHandlers() {
        return this.handlers;
    }

    @Override
    public FieldHandler getHandler(FieldType fieldType) {
        if (fieldType == null) {
            return null;
        }
        String handlerClass = fieldType.getManagerClass();
        if (StringUtils.isBlank((CharSequence)handlerClass)) {
            return null;
        }
        return (FieldHandler)CDIBeanLocator.getBeanByNameOrType((String)handlerClass);
    }
}

