/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.impl.AbstractFormProcessorImplTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SimpleDataFormProcessorImplTest
extends AbstractFormProcessorImplTest {
    public static final String ORIGINAL_TEXT = "originalText";
    public static final Integer ORIGINAL_INTEGER = 0;
    public static final Date ORIGINAL_DATE = new Date(System.currentTimeMillis() - 150000L);
    public static final String EXPECTED_TEXT = "expectedText";
    public static final Integer EXPECTED_INTEGER = 1234567890;
    public static final Date EXPECTED_DATE = new Date();

    @Test
    public void testPersistDataWithoutInputs() throws Exception {
        HashMap<String, Object> modifiedValues = new HashMap<String, Object>();
        modifiedValues.put("text", EXPECTED_TEXT);
        modifiedValues.put("int", EXPECTED_INTEGER);
        modifiedValues.put("date", EXPECTED_DATE);
        this.doTest(new HashMap<String, Object>(), modifiedValues);
    }

    @Test
    public void testPersistDataWithInputs() throws Exception {
        HashMap<String, Object> originalValues = new HashMap<String, Object>();
        originalValues.put("text", ORIGINAL_TEXT);
        originalValues.put("int", ORIGINAL_INTEGER);
        originalValues.put("date", ORIGINAL_DATE);
        HashMap<String, Object> modifiedValues = new HashMap<String, Object>();
        modifiedValues.put("text", EXPECTED_TEXT);
        modifiedValues.put("int", EXPECTED_INTEGER);
        modifiedValues.put("date", EXPECTED_DATE);
        this.doTest(originalValues, modifiedValues);
    }

    protected void doTest(Map<String, Object> inputs, Map<String, Object> modifiedValues) throws Exception {
        this.inputs.putAll(inputs);
        this.form = this.formGenerator.generateBasicForm();
        this.initContext();
        FormStatusData data = this.processor.read("ctxUID");
        Assert.assertNotNull((Object)data);
        for (Field field : this.form.getFormFields()) {
            Assert.assertEquals((Object)inputs.get(field.getFieldName()), (Object)data.getCurrentValue(field.getFieldName()));
        }
        Mockito.when((Object)this.processor.getFilteredMapRepresentationToPersist(this.context.getForm(), this.context.getUID())).thenReturn(modifiedValues);
        this.processor.persist("ctxUID");
        for (Field field : this.form.getFormFields()) {
            Object value = this.context.getOutputData().get(field.getFieldName());
            Assert.assertNotNull(value);
            Assert.assertEquals((Object)modifiedValues.get(field.getFieldName()), value);
        }
    }
}

