/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers.date;

import java.text.SimpleDateFormat;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.FieldType;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.FieldHandlersManager;
import org.jbpm.formModeler.core.processing.FormProcessingServices;
import org.jbpm.formModeler.core.processing.fieldHandlers.DefaultFieldHandlerFormatter;
import org.jbpm.formModeler.core.processing.fieldHandlers.FieldHandlerParametersReader;
import org.jbpm.formModeler.core.processing.fieldHandlers.date.DateFieldHandler;
import org.jbpm.formModeler.service.LocaleManager;
import org.jbpm.formModeler.service.bb.mvc.taglib.formatter.FormatterException;

@ApplicationScoped
@Named(value="DateFieldHandlerFormatter")
public class DateFieldHandlerFormatter
extends DefaultFieldHandlerFormatter {
    public static final String FLAT_SEPARATOR = "_";

    public void service(HttpServletRequest request, HttpServletResponse response) throws FormatterException {
        DateFieldHandler dateFieldHandler;
        FieldHandlerParametersReader paramsReader = new FieldHandlerParametersReader(request);
        Field field = paramsReader.getCurrentField();
        Form form = paramsReader.getCurrentForm();
        String namespace = paramsReader.getCurrentNamespace();
        Object value = paramsReader.getCurrentFieldValue();
        String fieldName = paramsReader.getCurrentFieldName();
        this.setDefaultAttributes(field, form, namespace);
        Boolean isReadonly = paramsReader.isFieldReadonly();
        if (isReadonly.booleanValue()) {
            this.setAttribute("readonly", isReadonly);
        }
        FieldHandlersManager fieldHandlersManager = FormProcessingServices.lookup().getFieldHandlersManager();
        if (StringUtils.isEmpty((CharSequence)field.getBag())) {
            dateFieldHandler = (DateFieldHandler)fieldHandlersManager.getHandler(field.getFieldType());
        } else {
            FieldType bagType = this.getFieldTypeManager().getTypeByClass(field.getBag());
            dateFieldHandler = (DateFieldHandler)fieldHandlersManager.getHandler(bagType);
        }
        String inputPattern = dateFieldHandler.getDefaultPattern();
        if (!StringUtils.isEmpty((CharSequence)dateFieldHandler.getDefaultPatterTimeSuffix())) {
            inputPattern = inputPattern + " " + dateFieldHandler.getDefaultPatterTimeSuffix();
        }
        SimpleDateFormat sdf = new SimpleDateFormat(inputPattern, LocaleManager.currentLocale());
        String dateValue = "";
        if (value != null) {
            dateValue = sdf.format(value);
        }
        String uid = this.namespaceManager.squashInputName(fieldName);
        this.setAttribute("uid", uid);
        this.setAttribute("flatUid", this.getFlatUid(uid));
        this.setAttribute("name", fieldName);
        this.setAttribute("value", dateValue);
        this.setAttribute("inputPattern", dateFieldHandler.getDefaultJQueryPattern());
        this.setAttribute("timePattern", dateFieldHandler.getDefaultPatterTimeSuffix());
        this.setAttribute("onChangeScript", field.getOnChangeScript());
        this.renderFragment("output");
    }

    public String getFlatUid(String uid) {
        uid = StringUtils.replace((String)uid, (String)"-", (String)FLAT_SEPARATOR);
        return StringUtils.replace((String)uid, (String)".", (String)FLAT_SEPARATOR);
    }
}

