/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers.multipleSubform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.processing.FormProcessor;
import org.jbpm.formModeler.core.processing.FormStatusData;
import org.jbpm.formModeler.core.processing.fieldHandlers.SubformFieldHandler;
import org.jbpm.formModeler.core.processing.fieldHandlers.subform.utils.SubFormHelper;
import org.jbpm.formModeler.core.rendering.SubformFinderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="org.jbpm.formModeler.core.processing.fieldHandlers.multipleSubform.CreateDynamicObjectFieldHandler")
public class CreateDynamicObjectFieldHandler
extends SubformFieldHandler {
    private static transient Logger log = LoggerFactory.getLogger(CreateDynamicObjectFieldHandler.class);
    public static final String CODE = "subformMultiple";
    @Inject
    private SubformFinderService subformFinderService;
    @Inject
    private FormProcessor formProcessor;
    @Inject
    private SubFormHelper helper;

    @Override
    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        Integer position;
        String[] editParams;
        boolean doSaveEdited;
        Form createForm;
        boolean addItemEnabled;
        String[] createParams;
        boolean doCreate;
        String[] tableEnterMode = (String[])parametersMap.get(inputName + "." + "tableEnterMode");
        boolean doTableEnterMode = tableEnterMode != null && tableEnterMode.length == 1 && tableEnterMode[0].equals("true");
        String[] sCount = (String[])parametersMap.get(inputName + "." + "count");
        int count = sCount != null && sCount.length == 1 ? Integer.valueOf(sCount[0]) : 0;
        Form form = this.getTableDataForm(field, inputName);
        Object[] previousValuesMap = (Map[])previousValue;
        if (doTableEnterMode && count > 0) {
            if (previousValuesMap == null) {
                previousValuesMap = new Map[count];
            }
            for (int i = 0; i < count; ++i) {
                String namespace = inputName + "." + i;
                this.formProcessor.setValues(form, namespace, parametersMap, filesMap);
                FormStatusData status = this.formProcessor.read(form, namespace);
                if (!status.isValid()) continue;
                Map objectCreated = this.formProcessor.getMapRepresentationToPersist(form, namespace);
                if (previousValuesMap[i] != null) {
                    previousValuesMap[i].putAll(objectCreated);
                    continue;
                }
                previousValuesMap[i] = objectCreated;
            }
        }
        boolean bl = doCreate = (createParams = (String[])parametersMap.get(inputName + "." + "create")) != null && createParams.length == 1 && createParams[0].equals("true");
        if (doCreate && (addItemEnabled = Boolean.TRUE.equals(this.formProcessor.getAttribute(createForm = this.getCreateForm(field, inputName), inputName, "-jbpm-doTheItemAdd")))) {
            this.formProcessor.setValues(createForm, inputName + "." + "create", parametersMap, filesMap);
            FormStatusData status = this.formProcessor.read(createForm, inputName + "." + "create");
            if (status.isValid()) {
                Map objectCreated = this.formProcessor.getMapRepresentationToPersist(createForm, inputName + "." + "create");
                if (previousValuesMap == null) {
                    previousValuesMap = new Map[]{};
                }
                previousValuesMap = (Map[])ArrayUtils.add((Object[])previousValuesMap, (Object)objectCreated);
                this.helper.clearExpandedField(inputName);
            }
        }
        boolean bl2 = doSaveEdited = (editParams = (String[])parametersMap.get(inputName + "." + "saveEdited")) != null && editParams.length == 1 && editParams[0].equals("true");
        if (doSaveEdited && (position = this.helper.getEditFieldPosition(inputName)) != null) {
            Form editForm = this.getEditForm(field, inputName);
            this.formProcessor.setValues(editForm, inputName, parametersMap, filesMap);
            FormStatusData status = this.formProcessor.read(editForm, inputName);
            if (status.isValid()) {
                Map objectCreated = this.formProcessor.getMapRepresentationToPersist(editForm, inputName);
                previousValuesMap[position].putAll(objectCreated);
                this.formProcessor.clear(editForm, inputName);
                this.helper.clearEditFieldPositions(inputName);
            }
        }
        return previousValuesMap;
    }

    @Override
    public Map getParamValue(Field field, String inputName, Object value) {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Object getStatusValue(Field field, String inputName, Object value, Map rootLoadedObjects) {
        if (value == null) {
            return new Map[0];
        }
        if (!rootLoadedObjects.containsKey(inputName)) {
            rootLoadedObjects.put(inputName, value);
        }
        Form form = this.getEnterDataForm(inputName, field);
        DataHolder holder = (DataHolder)form.getHolders().iterator().next();
        List values = (List)value;
        Map[] result = new Map[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            try {
                Object val = values.get(i);
                HashMap inputData = new HashMap();
                if (!StringUtils.isEmpty((CharSequence)holder.getInputId())) {
                    inputData.put(holder.getInputId(), val);
                }
                rootLoadedObjects.remove(holder.getUniqeId());
                result[i] = this.formProcessor.readValuesToLoad(form, inputData, new HashMap(), rootLoadedObjects, inputName + "." + i);
                continue;
            }
            catch (Exception e) {
                log.error("Error getting status value for field: " + inputName, (Throwable)e);
            }
        }
        HashMap<String, Map[]> loadedObjects = new HashMap<String, Map[]>();
        loadedObjects.put(holder.getUniqeId(), result);
        this.formProcessor.read(form, inputName, null, loadedObjects);
        return result;
    }

    @Override
    public Object persist(Field field, String inputName, Object fieldValue) throws Exception {
        if (fieldValue == null) {
            return null;
        }
        FormNamespaceData rootNamespaceData = this.getNamespaceManager().getRootNamespace(inputName);
        FormStatusData rootData = this.formProcessor.read(rootNamespaceData.getForm(), rootNamespaceData.getNamespace());
        Form form = this.getEnterDataForm(inputName, field);
        Object originalValue = rootData.getLoadedObject(inputName);
        List loadedObjects = null;
        loadedObjects = originalValue != null ? (List)originalValue : Collections.EMPTY_LIST;
        Map[] values = (Map[])fieldValue;
        ArrayList<Object> result = new ArrayList<Object>();
        List<Integer> removedValues = this.helper.getRemovedFieldPositions(inputName);
        if (removedValues != null) {
            for (int i = 0; i < removedValues.size(); ++i) {
                Integer removed = removedValues.get(i);
                if (removed >= loadedObjects.size()) continue;
                loadedObjects.remove(removed);
            }
        }
        DataHolder holder = (DataHolder)form.getHolders().iterator().next();
        for (int i = 0; i < values.length; ++i) {
            Object loadedObject = null;
            if (loadedObjects != null && loadedObjects.size() > i) {
                loadedObject = loadedObjects.get(i);
            }
            result.add(this.formProcessor.persistFormHolder(form, inputName + "." + i, values[i], holder, loadedObject));
        }
        this.helper.clearRemovedFieldPositions(inputName);
        return result;
    }

    public Form calculateFieldForm(Field field, String formPath, String namespace) {
        if (StringUtils.isEmpty((CharSequence)formPath)) {
            formPath = field.getDefaultSubform();
        }
        return this.subformFinderService.getFormByPath(formPath, namespace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deleteElementInPosition(Form form, String namespace, String field, int position) {
        Form form2 = form;
        synchronized (form2) {
            FormStatusData statusData = this.formProcessor.read(form, namespace);
            Object[] previousValue = statusData.getCurrentValue(field);
            if (previousValue != null) {
                Object[] vals = previousValue;
                if (position < vals.length) {
                    previousValue = ArrayUtils.remove((Object[])vals, (int)position);
                } else {
                    log.error("Cannot delete position " + position + " in array with size " + vals.length);
                }
            } else {
                log.error("Cannot delete position " + position + " in null array.");
            }
            return previousValue;
        }
    }

    public Form getCreateForm(Field field, String namespace) {
        try {
            return this.calculateFieldForm(field, field.getDefaultSubform(), namespace);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return null;
        }
    }

    public Form getPreviewDataForm(Field field, String namespace) {
        try {
            return this.calculateFieldForm(field, field.getPreviewSubform(), namespace);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return null;
        }
    }

    public Form getTableDataForm(Field field, String namespace) {
        try {
            return this.calculateFieldForm(field, field.getTableSubform(), namespace);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return null;
        }
    }

    public Form getEditForm(Field field, String namespace) {
        try {
            return this.calculateFieldForm(field, field.getDefaultSubform(), namespace);
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
            return null;
        }
    }
}

