/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers.multiple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.apache.commons.collections.CollectionUtils;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.FieldType;
import org.jbpm.formModeler.core.processing.DefaultFieldHandler;
import org.jbpm.formModeler.core.processing.FieldHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="org.jbpm.formModeler.core.processing.fieldHandlers.multiple.MultipleInputFieldHandler")
public class MultipleInputFieldHandler
extends DefaultFieldHandler {
    private Logger log = LoggerFactory.getLogger(MultipleInputFieldHandler.class);

    public String[] getCompatibleClassNames() {
        return new String[]{List.class.getName()};
    }

    public Object getValue(Field field, String inputName, Map parametersMap, Map filesMap, String desiredClassName, Object previousValue) throws Exception {
        ArrayList<Object> value = (ArrayList<Object>)previousValue;
        if (value == null) {
            value = new ArrayList<Object>();
        }
        FieldHandler handler = this.getFieldHandler(field);
        String[] newValue = (String[])parametersMap.get(inputName + "." + "addItem");
        String[] deleteValue = (String[])parametersMap.get(inputName + "." + "deleteItem");
        if (newValue != null && newValue.length == 1 && newValue[0].equals("true")) {
            try {
                Object valueToAdd = handler.getValue(field, inputName, parametersMap, filesMap, field.getBag(), null);
                value.add(valueToAdd);
            }
            catch (Exception ex) {
                this.log.debug("Unable to add value to list '{}': {}", (Object)field.getFieldName(), (Object)ex);
                throw new Exception("Unable to add value");
            }
        } else if (deleteValue != null && deleteValue.length == 1 && !deleteValue[0].equals("-1")) {
            int index = Integer.decode(deleteValue[0]);
            if (index <= value.size()) {
                value.remove(index);
            }
        } else if (!value.isEmpty()) {
            for (int i = 0; i < value.size(); ++i) {
                try {
                    value.set(i, handler.getValue(field, inputName + "." + i, parametersMap, filesMap, field.getBag(), value.get(i)));
                    continue;
                }
                catch (Exception ex) {
                    this.log.debug("Unable to edit value '{}' on list '{}': {}", new Object[]{i, field.getFieldName(), ex});
                    throw new Exception("Unable to edit value");
                }
            }
        }
        return value;
    }

    public Map getParamValue(Field field, String inputName, Object objectValue) {
        HashMap result = new HashMap();
        List values = (List)objectValue;
        if (CollectionUtils.isEmpty((Collection)values)) {
            return result;
        }
        FieldHandler handler = this.getFieldHandler(field);
        if (values != null && values.size() > 0) {
            for (int i = 0; i < values.size(); ++i) {
                result.putAll(handler.getParamValue(field, inputName + "." + i, values.get(i)));
            }
        }
        return result;
    }

    public boolean isEmpty(Object value) {
        return CollectionUtils.isEmpty((Collection)((List)value));
    }

    protected FieldHandler getFieldHandler(Field field) {
        FieldType bagFieldType = this.getFieldTypeManager().getTypeByClass(field.getBag());
        if (bagFieldType != null) {
            return this.getFieldHandlersManager().getHandler(bagFieldType);
        }
        return null;
    }
}

