/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formStatus;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jbpm.formModeler.api.model.Form;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormStatus
implements Serializable {
    private static transient Logger log = LoggerFactory.getLogger(FormStatus.class);
    private Map<String, Object> inputValues = new HashMap<String, Object>();
    private Map lastParameterMap;
    private Form relatedForm;
    private Set wrongFields = new TreeSet();
    private Map<String, List> wrongFieldsMessages = new HashMap<String, List>();
    private String namespace;
    private Map attributes = new HashMap();
    private Map<String, Object> loadedObjects = new HashMap<String, Object>();

    public FormStatus(Form relatedForm, String namespace, Map currentValues) {
        this.relatedForm = relatedForm;
        this.namespace = namespace;
        if (currentValues != null) {
            this.inputValues.putAll(currentValues);
        }
    }

    public Map getInputValues() {
        return this.inputValues;
    }

    public Map getLastParameterMap() {
        return this.lastParameterMap;
    }

    public void setLastParameterMap(Map lastParameterMap) {
        this.lastParameterMap = lastParameterMap;
    }

    public Set getWrongFields() {
        return this.wrongFields;
    }

    public Form getRelatedForm() {
        return this.relatedForm;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected void clear() {
        this.inputValues.clear();
        this.attributes.clear();
        this.lastParameterMap = null;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public void clearFormErrors() {
        this.wrongFields.clear();
        this.wrongFieldsMessages.clear();
    }

    public void removeWrongField(String fieldName) {
        this.wrongFields.remove(fieldName);
        this.wrongFieldsMessages.remove(fieldName);
    }

    public List getErrorMessage(String fieldName) {
        return this.wrongFieldsMessages.get(fieldName);
    }

    public void addErrorMessages(String fieldName, List messages) {
        this.wrongFields.add(fieldName);
        this.wrongFieldsMessages.put(fieldName, messages);
    }

    public Map getWrongFieldsMessages() {
        return this.wrongFieldsMessages;
    }

    public void setWrongFieldsMessages(Map wrongFieldsMessages) {
        this.wrongFieldsMessages = wrongFieldsMessages;
    }

    public Map<String, Object> getLoadedObjects() {
        return this.loadedObjects;
    }

    public void setLoadedObjects(Map<String, Object> loadedObjects) {
        this.loadedObjects = loadedObjects;
    }

    public void addLoadedObject(String id, Object obj) {
        this.loadedObjects.put(id, obj);
    }

    public Object getLoadedObject(String id) {
        return this.loadedObjects.get(id);
    }
}

