/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.impl.util;

import java.util.Date;
import java.util.List;
import java.util.Random;
import org.jbpm.formModeler.api.model.DataHolder;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.FieldType;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.config.FieldTypeManager;
import org.jbpm.formModeler.core.model.BasicTypeDataHolder;
import org.jbpm.formModeler.core.model.PojoDataHolder;
import org.jbpm.formModeler.core.processing.impl.model.Address;
import org.jbpm.formModeler.core.processing.impl.model.Hobby;
import org.jbpm.formModeler.core.processing.impl.model.Person;

public class TestFormGenerator {
    public static final Long BASIC_FORM_ID = 3L;
    public static final String TEXT_FIELD = "text";
    public static final String INT_FIELD = "int";
    public static final String DATE_FIELD = "date";
    public static final Long PERSON_FORM_ID = 0L;
    public static final String PERSON_DATAHOLDER = "person";
    public static final String NAME_FIELD = "name";
    public static final String SURNAME_FIELD = "surname";
    public static final String BIRTHDAY_FIELD = "birthday";
    public static final String ADDRESS_FIELD = "address";
    public static final String HOBBIES_FIELD = "hobbies";
    public static final Long ADDRESS_FORM_ID = 1L;
    public static final String ADDRESS_DATAHOLDER = "address";
    public static final String STREET_FIELD = "street";
    public static final String NUM_FIELD = "num";
    public static final String HOBBY_DATAHOLDER = "hobby";
    public static final Long HOBBY_FORM_ID = 2L;
    public static final String LEVEL_FIELD = "level";
    public static final Long MULTIPLE_SUB_FORM_ID = 4L;
    public static final String HOBBIES_DATA_HOLDER = "hobbies";
    private FieldTypeManager fieldTypeManager;

    public TestFormGenerator(FieldTypeManager fieldTypeManager) {
        this.fieldTypeManager = fieldTypeManager;
    }

    public Form generateBasicForm() {
        Form form = new Form();
        form.setName(Person.class.getName());
        form.setId(BASIC_FORM_ID);
        form.getFormFields().add(this.getSimpleField(TEXT_FIELD, TEXT_FIELD, String.class.getName(), form));
        form.getFormFields().add(this.getSimpleField(INT_FIELD, INT_FIELD, Integer.class.getName(), form));
        form.getFormFields().add(this.getSimpleField(DATE_FIELD, DATE_FIELD, Date.class.getName(), form));
        form.setDataHolder((DataHolder)new BasicTypeDataHolder(TEXT_FIELD, TEXT_FIELD, TEXT_FIELD, String.class.getName(), ""));
        form.setDataHolder((DataHolder)new BasicTypeDataHolder(INT_FIELD, INT_FIELD, INT_FIELD, Integer.class.getName(), ""));
        form.setDataHolder((DataHolder)new BasicTypeDataHolder(DATE_FIELD, DATE_FIELD, DATE_FIELD, Date.class.getName(), ""));
        return form;
    }

    public Form generatePersonForm() {
        Form form = new Form();
        form.setName(Person.class.getName());
        form.setId(PERSON_FORM_ID);
        form.getFormFields().add(this.getSimpleField(NAME_FIELD, "person/name", String.class.getName(), form));
        form.getFormFields().add(this.getSimpleField(SURNAME_FIELD, "person/surname", String.class.getName(), form));
        form.getFormFields().add(this.getSimpleField(BIRTHDAY_FIELD, "person/birthday", Date.class.getName(), form));
        Field address = this.getComplexField("address", "person/address", Object.class.getName(), form);
        address.getFieldType().setFieldClass(Address.class.getName());
        address.setDefaultSubform(ADDRESS_FORM_ID.toString());
        form.getFormFields().add(address);
        Field hobbies = this.getComplexField("hobbies", "person/hobbies", List.class.getName(), form);
        hobbies.setBag(Hobby.class.getName());
        hobbies.setDefaultSubform(HOBBY_FORM_ID.toString());
        form.getFormFields().add(hobbies);
        form.setDataHolder((DataHolder)new PojoDataHolder(PERSON_DATAHOLDER, PERSON_DATAHOLDER, PERSON_DATAHOLDER, Person.class.getName(), ""));
        return form;
    }

    public Form generateHobbyForm() {
        Form form = new Form();
        form.setName(Hobby.class.getName());
        form.setId(HOBBY_FORM_ID);
        form.getFormFields().add(this.getSimpleField(NAME_FIELD, "hobby/name", String.class.getName(), form));
        form.getFormFields().add(this.getSimpleField(LEVEL_FIELD, "hobby/level", Integer.class.getName(), form));
        form.setDataHolder((DataHolder)new PojoDataHolder(HOBBY_DATAHOLDER, HOBBY_DATAHOLDER, HOBBY_DATAHOLDER, Hobby.class.getName(), ""));
        return form;
    }

    public Form generateAddressForm() {
        Form form = new Form();
        form.setName(Address.class.getName());
        form.setId(ADDRESS_FORM_ID);
        form.getFormFields().add(this.getSimpleField(STREET_FIELD, "address/street", String.class.getName(), form));
        form.getFormFields().add(this.getSimpleField(NUM_FIELD, "address/num", Integer.class.getName(), form));
        form.setDataHolder((DataHolder)new PojoDataHolder("address", "address", "address", Address.class.getName(), ""));
        return form;
    }

    public Form generateMultipleSubformForm() {
        Form form = new Form();
        form.setName(List.class.getName());
        form.setId(MULTIPLE_SUB_FORM_ID);
        Field hobbies = this.getComplexField("hobbies", "hobbies", List.class.getName(), form);
        hobbies.setBag(Hobby.class.getName());
        hobbies.setDefaultSubform(HOBBY_FORM_ID.toString());
        form.getFormFields().add(hobbies);
        form.setDataHolder((DataHolder)new BasicTypeDataHolder("hobbies", "hobbies", "hobbies", List.class.getName(), ""));
        return form;
    }

    private Field getSimpleField(String name, String binding, String className, Form form) {
        FieldType type = this.fieldTypeManager.getSimpleTypeByClass(className);
        return this.getFieldFor(name, binding, type, form);
    }

    private Field getComplexField(String name, String binding, String className, Form form) {
        FieldType type = this.fieldTypeManager.getComplexTypeByClass(className);
        return this.getFieldFor(name, binding, type, form);
    }

    private Field getFieldFor(String name, String binding, FieldType type, Form form) {
        Random randomGenerator = new Random();
        Field field = new Field();
        field.setId(Long.valueOf((long)randomGenerator.nextInt(1000) * System.currentTimeMillis()));
        field.setFieldName(name);
        field.setInputBinding(binding);
        field.setOutputBinding(binding);
        field.setFieldType(type);
        field.setForm(form);
        field.setPosition(form.getFormFields().size());
        return field;
    }
}

