/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.formStatus;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import org.apache.commons.lang3.StringUtils;
import org.jbpm.formModeler.api.model.Form;
import org.jbpm.formModeler.core.processing.FormNamespaceData;
import org.jbpm.formModeler.core.processing.formProcessing.NamespaceManager;
import org.jbpm.formModeler.core.processing.formStatus.FormStatus;
import org.jbpm.formModeler.service.cdi.CDIBeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SessionScoped
public class FormStatusManager
implements Serializable {
    private Logger log = LoggerFactory.getLogger(FormStatusManager.class);
    private transient Map formStatuses = new Hashtable();

    public static FormStatusManager lookup() {
        return (FormStatusManager)CDIBeanLocator.getBeanByType(FormStatusManager.class);
    }

    public FormStatus getFormStatus(Form form, String namespace) {
        namespace = (String)StringUtils.defaultIfEmpty((CharSequence)namespace, (CharSequence)"NS");
        return (FormStatus)this.formStatuses.get(namespace + "-" + form.getId());
    }

    public FormStatus createFormStatus(Form form, String namespace, Map<String, Object> currentValues) {
        namespace = (String)StringUtils.defaultIfEmpty((CharSequence)namespace, (CharSequence)"NS");
        FormStatus fs = new FormStatus(form, namespace, currentValues);
        this.formStatuses.put(namespace + "-" + form.getId(), fs);
        return fs;
    }

    public void destroyFormStatus(Long formId, String namespace) {
        namespace = (String)StringUtils.defaultIfEmpty((CharSequence)namespace, (CharSequence)"NS");
        String requestedPreffix = namespace + "-" + formId;
        Iterator it = this.formStatuses.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(requestedPreffix)) continue;
            it.remove();
        }
    }

    public void cascadeClearWrongFields(Long formId, String namespace) {
        namespace = (String)StringUtils.defaultIfEmpty((CharSequence)namespace, (CharSequence)"NS");
        String requestedPreffix = namespace + "-" + formId;
        for (String key : this.formStatuses.keySet()) {
            if (!key.startsWith(requestedPreffix)) continue;
            FormStatus formStatus = (FormStatus)this.formStatuses.get(key);
            formStatus.clearFormErrors();
        }
    }

    public FormStatus getParent(FormStatus fs) {
        if (fs == null) {
            return null;
        }
        String namespace = fs.getNamespace();
        if (StringUtils.isEmpty((CharSequence)namespace)) {
            return null;
        }
        FormNamespaceData fsd = NamespaceManager.lookup().getNamespace(namespace);
        if (fsd == null) {
            return null;
        }
        return this.getFormStatus(fsd.getForm(), fsd.getNamespace());
    }
}

