/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.formModeler.core.processing.fieldHandlers;

import javax.servlet.http.HttpServletRequest;
import org.jbpm.formModeler.api.model.Field;
import org.jbpm.formModeler.api.model.Form;

public class FieldHandlerParametersReader {
    private HttpServletRequest httpServletRequest;

    public FieldHandlerParametersReader(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public Form getCurrentForm() {
        Field field = (Field)this.httpServletRequest.getAttribute("_ddm_currentField");
        if (field != null) {
            return field.getForm();
        }
        return null;
    }

    public int getCurrentPosition() {
        Field field = (Field)this.httpServletRequest.getAttribute("_ddm_currentField");
        if (field != null) {
            return field.getPosition();
        }
        return -1;
    }

    public Field getCurrentField() {
        Field field = (Field)this.httpServletRequest.getAttribute("_ddm_currentField");
        if (field != null) {
            return field;
        }
        return null;
    }

    public Object getCurrentFieldValue() {
        return this.httpServletRequest.getAttribute("_ddm_currentValue");
    }

    public String getCurrentFieldName() {
        return (String)this.httpServletRequest.getAttribute("_ddm_currentName");
    }

    public String getCurrentNamespace() {
        return (String)this.httpServletRequest.getAttribute("_ddm_currentNamespace");
    }

    public boolean isWrongField() {
        Boolean b = (Boolean)this.httpServletRequest.getAttribute("_ddm_currentFieldIsWrong");
        return b != null && b != false;
    }

    public String getInputValue() {
        return (String)this.httpServletRequest.getAttribute("_ddm_currentInputValue");
    }

    public Boolean isFieldReadonly() {
        Boolean b = (Boolean)this.httpServletRequest.getAttribute("_ddm_fieldIsReadonly");
        return b != null ? b : Boolean.FALSE;
    }

    public String getCurrentRenderMode() {
        return (String)this.httpServletRequest.getAttribute("_ddm_current_renderMode");
    }

    public boolean isEditingForm() {
        String renderMode = this.getCurrentRenderMode();
        return "wysiwyg-form".equals(renderMode) || "wysiwyg-display".equals(renderMode);
    }
}

